/**
 * 系统中使用的工具
 * 包括 任务生成规则
 * 包括 key生成规则
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");

const md5 = require("md5");


/**
 * 生成任务id
 * @param uscc 企业标识
 * @returns 
 */
export function getTaskId(uscc:string) {
    return `${uscc}${getTimeKey()}`;
}


/**
 * 根据时间生成任务id
 * @param uscc 企业标识
 * @param timeMs 时间戳
 * @returns 
 */
export function getTaskIdByTime(uscc:string, timeMs:number) {
    return `${uscc}${new Date(timeMs).getFullYear()}${new Date(timeMs).getMonth() + 1 }`;
}


/**
 * 获取当前日期的key
 * @param timeMs 指定时间，如果不传
 * @returns 
 */
export function getTimeKey(timeMs?) {
    if (timeMs) return parseInt(`${new Date(timeMs).getFullYear()}${new Date(timeMs).getMonth() + 1 }`);
    return parseInt(`${new Date().getFullYear()}${new Date().getMonth() + 1 }`);
}


/**
 * 获取上一个月日期的key
 * @param timeMs 指定时间，如果不传
 * @returns 
 */
export function getLastMonthTimeKey() {
    let time = moment().subtract(1, 'months').valueOf();
    return parseInt(`${new Date(time).getFullYear()}${new Date(time).getMonth() + 1 }`);
}


/**
 * 获取上一月的日期的key
 * @returns 
 */
export function getLastTimeKey() {
    return moment().subtract(1,'months').format('YYYYM');
}


/**
 * 生成草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}


/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}

/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 校验uscc是否合法
 * @param uscc 
 * @returns true/false 
 */
export function eccUscc(uscc:string) {
    let isSuccess = false;
    if (uscc.search(/^[A-Za-z0-9]{16}$/) > -1) isSuccess = true;
    else if (uscc.search(/^[A-Za-z0-9]{18}$/) > -1) isSuccess = true;
    return isSuccess;
}


/**
 * 获取绑定id
 * @param uscc 孵化器统一信用代码
 * @param bindUscc 被绑定的孵化器统一信用代码
 * @returns 
 */
export function getBindId(uscc:string, bindUscc:string) {
    return md5(`${uscc}${bindUscc}${Math.ceil(Math.random() *100)}`);
} 


/**
 * 获取今天开始时刻的时间戳  0时0分
 * @returns 
 */
export function getTodayMs() {
    let t =`${ moment().format("YYYY-MM-DD")} 00:00:00`;
    return new Date(t).valueOf();
}

/**
 * 获取这个月的开始时刻的时间戳  0时0分
 * @returns 
 */
export function getThisMonthMs() {
    let t =`${ moment().format("YYYY-MM")}-01 00:00:00`;
    return new Date(t).valueOf();
}


/**
 * 获取code的id
 * @param uscc 发送人的uscc
 * @param todaySendCount 今日发送次数
 * @returns ''
 */
export function getSMSCodeId(uscc:string, todaySendCount:number) {
    return md5(`${uscc}${todaySendCount}${new Date().valueOf()}`);
}


/**
 * 获取一个随机6位数的验证码
 * @returns 
 */
export function getSMSCode() {
    let code = ``;
    for (let i =0; i < 6; i++) {
        code += Math.floor(Math.random() * 10)
    }
    return code;
}


/**
 * 获取融资id
 * @param uscc 
 * @returns 
 */
export function getFinancingId(uscc) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() * 1000)}`);
}


/**
 * 获取创始团队成员id
 * @param uscc 
 * @param name 
 * @returns 
 */
export function getInitialTeamMemberId(uscc:string, name:string) {
    return md5(`${uscc}${name}${Math.ceil(Math.random() * 1000000)}`);
}