/**
 * 小程序端  孵化器入口  孵化器相关路由
 * 包括 孵化器数据相关
 * 包括 孵化器任务相关
 */

import * as asyncHandler from 'express-async-handler';
import * as baseBiz from '../../biz/mobileFuHuaQi/fuHuaQi/base';
import * as taskBiz from '../../biz/mobileFuHuaQi/fuHuaQi/task';
import * as scoreBiz from '../../biz/mobileFuHuaQi/fuHuaQi/score';
import { eccReqParamater } from '../../util/verificationParam';
import { checkFuHuaQiToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/base', checkFuHuaQiToken, asyncHandler(baseInfo));
    /**我的数据 */
    httpServer.post('/fuhuaqi/base/mydata', checkFuHuaQiToken, asyncHandler(myDataInfo));
    httpServer.post('/fuhuaqi/base/update', checkFuHuaQiToken, asyncHandler(updateMyDataInfo));
    /**机构信息（我的信息） */
    httpServer.post('/fuhuaqi/organization/info', checkFuHuaQiToken, asyncHandler(organizationInfo));
    httpServer.post('/fuhuaqi/organization/update', checkFuHuaQiToken, asyncHandler(updateOrganizationInfo));
    /** 任务 */
    httpServer.post('/fuhuaqi/task/list', checkFuHuaQiToken, asyncHandler(taskList));//待办任务
    httpServer.post('/fuhuaqi/task/submit', checkFuHuaQiToken, asyncHandler(submitTask));//提交待办任务
    httpServer.post('/fuhuaqi/task/completedlist', checkFuHuaQiToken, asyncHandler(completedList));//已办任务
    httpServer.post('/fuhuaqi/task/pastduelist', checkFuHuaQiToken, asyncHandler(pastDueList));//已办任务
    /**分数 */
    httpServer.post('/fuhuaqi/score/ranklist', checkFuHuaQiToken, asyncHandler(scoreRankList));
    httpServer.post('/fuhuaqi/score/log', checkFuHuaQiToken, asyncHandler(scoreLog));
}


/**
 * 主界面信息 
 * 首页的几个孵化器数据和评分明细
 * 登录进来会调用
 * 1.0
 * @param req 
 * @param res 
 */
async function baseInfo(req, res) {
    const Uscc = req.headers.uscc;
    let userInfo = await baseBiz.homeData(Uscc);
    let scoreInfo = await scoreBiz.getFuHuaQiScore(Uscc);
    let result = Object.assign(userInfo, { scoreInfo } );
    res.success(result);
}


/**
 * 我的数据 
 * 小程序点击 我的数据
 * 1.0
 * @param req 
 * @param res 
 */
async function myDataInfo(req, res) {
    const Uscc = req.headers.uscc;
    let userInfo = await baseBiz.selectFuHuaQiBaseData(Uscc);
    res.success(userInfo);
}


/**
 * 更新基础数据
 * 1.0
 * @param req 
 * @param res 
 */
async function updateMyDataInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await baseBiz.updateFuHuaQiBaseData(Uscc, form);
    res.success(result);
}


/**
 * 机构信息 
 * 改成了我的信息(2.23日修改)
 * 1.0
 * @param req 
 * @param res 
 */
async function organizationInfo(req, res) {
    const Uscc = req.headers.uscc;
    let userInfo = await baseBiz.selectOrganizationInfo(Uscc);
    res.success(userInfo);
}


/**
 * 修改机构信息
 * 1.0
 * @param req 
 * @param res 
 */
async function updateOrganizationInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await baseBiz.updateOrganizationData(Uscc, form);
    res.success(result);
}


/**
 * 任务列表
 * 1.0
 * @param req 
 * @param res 
 */
async function taskList(req, res) {
    const Uscc = req.headers.uscc;
    let taskListObj = await taskBiz.fuHuaQiTaskList(Uscc);
    /**拼接分数 */
    // let scoreObj = await scoreBiz.MyScore(Uscc);
    let scoreObj = {};
    let result = Object.assign(scoreObj, taskListObj);
    res.success(result);
}


/**
 * 提交任务
 * 1.0
 * @param req 
 * @param res 
 */
async function submitTask(req, res) {
    let reqConf = {taskType:'Number'};
    let { taskType } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await taskBiz.checkTask(Uscc, taskType);
    res.success(result);
}


/**
 * 已办任务
 * 2.0
 * @param req 
 * @param res 
 */
async function completedList(req, res) {
    let reqConf = {selectTime:'Number'};
    let { selectTime } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;
     

    let result = await taskBiz.fuHuaQiCompletedList(Uscc, selectTime);

    res.success(result);
}


/**
 * 过期任务
 * 2.0
 * @param req 
 * @param res 
 */
async function pastDueList(req, res) {
    let reqConf = {selectTime:'Number'};
    let { selectTime } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await taskBiz.fuHuaQiPastdueList(Uscc, selectTime);

    res.success(result);
}


async function scoreLog(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {year:'Number'};
    let { year } = eccReqParamater(reqConf, req.body);
    let result = await scoreBiz.fuHuaQiScoreLog(Uscc, year);
    res.success(result);
}

async function scoreRankList(req, res) {
    const Uscc = req.headers.uscc;
    let result = await scoreBiz.rankList(Uscc);
    res.success(result);
}