/**
 * 小程序端  企业入口  数据申报相关接口
 */

import * as asyncHandler from 'express-async-handler';
import { checkEnterpriseToken } from '../../middleware/user';
import * as dataDeclarationBiz from '../../biz/mobileEnterprise/dataDeclaration';
import { eccReqParamater } from '../../util/verificationParam';


export function setRouter(httpServer) {
    httpServer.post('/enterprise/datadeclaration/todo', checkEnterpriseToken, asyncHandler(unsubmitted));
    httpServer.post('/enterprise/datadeclaration/completed', checkEnterpriseToken, asyncHandler(completed));
    httpServer.post('/enterprise/datadeclaration/submit', checkEnterpriseToken, asyncHandler(submitDataDeclaration) );
    /**经营数据 */
    httpServer.post('/enterprise/datadeclaration/businessdata/add', checkEnterpriseToken, asyncHandler(addBusiness));
    httpServer.post('/enterprise/datadeclaration/businessdata/update', checkEnterpriseToken, asyncHandler(updateBusiness));
    httpServer.post('/enterprise/datadeclaration/businessdata/info', checkEnterpriseToken, asyncHandler(businessInfo));
    /**团队数据 */
    httpServer.post('/enterprise/datadeclaration/team/add', checkEnterpriseToken, asyncHandler(addTeamData));
    httpServer.post('/enterprise/datadeclaration/team/info', checkEnterpriseToken, asyncHandler(teamInfo));
    httpServer.post('/enterprise/datadeclaration/team/update', checkEnterpriseToken, asyncHandler(updateTeamData));
    
}


/**
 * 待申报列表
 * @param req 
 * @param res 
 */
async function unsubmitted(req, res) {
    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.todoList(Uscc);
    res.success(result);
}


/**
 * 已申报列表
 * @param req 
 * @param res 
 */
async function completed(req, res) {
    let reqConf = {year:'Number', quarter:'Number'};
    let {year, quarter} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.completedList(Uscc, year, quarter);
    res.success(result);
}


/**
 * 提交申报经营状况数据
 * @param req 
 * @param res 
 */
async function addBusiness(req, res) {
    let reqConf = {BI:'Number', RD:'Number', TXP:'Number'};
    let {BI, RD, TXP} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.addBusinessData(Uscc, BI, RD, TXP);
    res.success(result);
}


/**
 * 修改经营状况数据
 * @param req 
 * @param res 
 */
async function updateBusiness(req, res) {
    let reqConf = {BI:'Number', RD:'Number', TXP:'Number'};
    let {BI, RD, TXP} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.updateBusinessData(Uscc, BI, RD, TXP);
    res.success(result);
}


/**
 * 经营状况数据详情
 * 回显
 * @param req 
 * @param res 
 */
async function businessInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.businessInfo(Uscc );
    res.success(result);
}


/**
 * 添加团队信息数据
 * @param req 
 * @param res 
 */
async function addTeamData(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let { form } = eccReqParamater(reqConf, req.body);

    let result = await dataDeclarationBiz.addTeamInfo(Uscc, form);
    res.success(result);
}

/**
 * 团队信息数据
 * 回显
 * @param req 
 * @param res 
 */
async function teamInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.getTeamInfo(Uscc );
    res.success(result);
}


/**
 * 修改团队信息数据
 * @param req 
 * @param res 
 */
async function updateTeamData(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let { form } = eccReqParamater(reqConf, req.body);

    let result = await dataDeclarationBiz.updateTeamInfo(Uscc, form);
    res.success(result);
}



/**
 * 修改团队信息数据
 * @param req 
 * @param res 
 */
async function submitDataDeclaration(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {type:'Number'};
    let { type } = eccReqParamater(reqConf, req.body);

    let result = await dataDeclarationBiz.submit(Uscc, type);
    res.success(result);
}
