/**
 * 小程序端  企业入口  经营数据接口
 */

import * as asyncHandler from 'express-async-handler';
import { checkEnterpriseToken } from '../../middleware/user';
import * as businessDataBiz from '../../biz/mobileEnterprise/businessData';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/enterprise/businessdata/homepage', checkEnterpriseToken, asyncHandler(homePageBusinessData));
    /**可修改的经营数据 */
    httpServer.post('/enterprise/businessdata/info', checkEnterpriseToken, asyncHandler(lastYearBusinessData));
    httpServer.post('/enterprise/businessdata/replenish', checkEnterpriseToken, asyncHandler(replenishData));
}


/**
 * 首页经营数据
 * @param req 
 * @param res 
 */
async function homePageBusinessData(req, res) {
    const Uscc = req.headers.uscc;
    let result = await businessDataBiz.getBusinessData(Uscc);
    res.success(result);
}


/**
 * 特定类型经营数据
 * @param req 
 * @param res 
 */
async function lastYearBusinessData(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {type:'Number'};
    let {type} = eccReqParamater(reqConf, req.body);
    
    let result = await businessDataBiz.lastYearBusinessData(Uscc, type);
    res.success(result);
}


/**
 * 补录经营数据
 * @param req 
 * @param res 
 */
async function replenishData(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = { data:"[Number]", type:"Number" };
    let {data, type} = eccReqParamater(reqConf, req.body);
    
    let result = await businessDataBiz.replenishBusinessData(Uscc, type, data);
    res.success(result);
}
