/**
 * 小程序端  企业入口  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import { checkEnterpriseToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as enterpriseBiz from '../../biz/mobileEnterprise/enterprise';
import * as dataDeclarationBiz from '../../biz/mobileEnterprise/dataDeclaration';


export function setRouter(httpServer) {
    /**首页 */
    httpServer.post('/enterprise/base/headeinfo', checkEnterpriseToken, asyncHandler(homePageHeaderInfo));
    /**基本信息 */
    httpServer.post('/enterprise/base/info', checkEnterpriseToken, asyncHandler(baseInfo));
    httpServer.post('/enterprise/base/update', checkEnterpriseToken, asyncHandler(updateBaseInfo));
    /**创始团队 */
    httpServer.post('/enterprise/initialteam/update', checkEnterpriseToken, asyncHandler(updateTeamsState));
    httpServer.post('/enterprise/initialteam/info', checkEnterpriseToken, asyncHandler(initialTeamInfo));
    /**知识产权 */
    httpServer.post('/enterprise/intellectualproperty/update', checkEnterpriseToken, asyncHandler(updateIntellectualproperty));
    httpServer.post('/enterprise/intellectualproperty/info', checkEnterpriseToken, asyncHandler(intellectualpropertyInfo));
    /**企业资质 */
    httpServer.post('/enterprise/qualification/update', checkEnterpriseToken, asyncHandler(updateQualification));
    httpServer.post('/enterprise/qualification/info', checkEnterpriseToken, asyncHandler(qualificationInfo));
    /**资讯 */
    httpServer.post('/enterprise/information/list', checkEnterpriseToken, asyncHandler(informationList));
    /**团队信息 */
    httpServer.post('/enterprise/team/info', checkEnterpriseToken, asyncHandler(showTeamInfomation));
}


/**
 * 首页数据 顶部信息
 * @param req 
 * @param res 
 */
async function homePageHeaderInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.getHomePageHeaderData(Uscc);
    res.success(result);
}


/**
 * 修改团队状态
 * @param req 
 * @param res 
 */
async function updateTeamsState(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {firstClassTalent:'Number', teams:'[Object]'};
    let {firstClassTalent, teams} = eccReqParamater(reqConf, req.body, ["teams"]);
    
    let result = await enterpriseBiz.updateInitialTeamInfo(Uscc, firstClassTalent, teams);

    res.success(result);
}


/**
 * 创始团队信息
 * @param req 
 * @param res 
 */
async function initialTeamInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.selectInitialTeamInfo(Uscc);

    res.success(result);
}


/**
 * 修改知识产权信息
 * @param req 
 * @param res 
 */
async function updateIntellectualproperty(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {alienPatent:'Number', classIPatent:'Number', secondClassPatent:'Number'};
    let {alienPatent, classIPatent, secondClassPatent} = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.updateIntellectualProperty(Uscc, alienPatent, classIPatent, secondClassPatent);

    res.success(result);
}


/**
 * 查询知识产权信息
 * @param req 
 * @param res 
 */
async function intellectualpropertyInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.selectIntellectualProperty(Uscc);

    res.success(result);
}


/**
 * 查询企业资质信息
 * @param req 
 * @param res 
 */
async function qualificationInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.selectQualification(Uscc);

    res.success(result);
}

/**
 * 修改知识产权信息
 * @param req 
 * @param res 
 */
async function updateQualification(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let {form} = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.updateQualification(Uscc, form);

    res.success(result);
}


/**
 * 修改企业基本信息
 * @param req 
 * @param res 
 */
async function updateBaseInfo(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let {form} = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.updateEnterpriseBaseInfo(Uscc, form);

    res.success(result);
}

/**
 * 查询企业基本信息
 * @param req 
 * @param res 
 */
async function baseInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.enterpriseBaseInfo(Uscc);

    res.success(result);
}


/**
 * 点击查看团队信息数据
 * @param req 
 * @param res 
 */
async function showTeamInfomation(req, res) {
    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.showTeamInfo(Uscc );
    res.success(result);
}




async function informationList(req, res) {
    const Uscc = req.headers.uscc;
    
}