/**
 * 企业资讯
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';

const informationSchema = new Schema({
    id:{type:String, index:true},//唯一标识
    desc:String,//描述
    createTimeMs:Number,//创建时间
    imgs:{type:[String], default:[]},
    author:String,
    createUid:String,
    target:{type:[Number], default:[]},//标签
    noAutomatic:{type:Boolean, default:false},//非自动状态  true=关闭，false=开启
});

var informationModel;
export function initModel(){
    informationModel = baseDB.model('information', informationSchema);
    informationModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await informationModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 创建资讯
 * @param id 
 * @param desc 
 * @param createTimeMs 
 * @param author 
 * @param createUid 
 * @param target 
 */
export async function createInformation(id:string, desc:string, imgs,author:string, createUid:string, target:number ) {
    // let addInfo = {id, desc, createTimeMs, imgs, author, createUid, target, noAutomatic};

}