
/**
 * 孵化器任务填报类型
 */
export enum TASKTYPEENUM {
    孵化器月度填报=1,
    融资企业填报,
    新注册或迁入企业登记
}

/**
 * 孵化器级别
 */
export enum FUHUAQILV {
    国家级众创空间 = 1,
    市级众创空间,
    国家级孵化器,
    市级孵化器,
    区级
}


/**
 * 孵化器创业团队
 */
export enum TEAM {
    无 = 1,
    国际一流人才,
    国内一流人才
}


/**
 * 创始团队  【企业端用】
 */
export enum ENTERPRISETEAM {
    国际一流人才=2,
    国内一流人才
}


/**
 * 运营模式
 */
export enum OPERATIONMODEL {
    链接国际资源类型 = 1,
    深挖科研创新资源类型,
    _投资__孵化_类型,
    搭建行业共性技术创新平台类型,
    推动未来产业集聚类型,
    其他,
}


/**
 * 孵化器机构性质
 */

export enum INSTITUTIONALNATURE {
    国资为主 = 1,
    民资为主,
    外资为主
}

/**
 * 孵化器投资方式
 */
export enum FUHUAQILNVESTMENTSTYLE {
    自有资金 = 1,
    自有基金,
    参与基金
}

/**
 * 孵化器孵化领域
 */
export enum FUHUAINDUSTRY{
    集成电路 = 1,
    生物医药,
    人工智能及智能制造,
    航空航天,
    汽车产业,
    软件和信息服务业,
    低碳环保及新材料,
    综合,
    文化创意
}

/**
 * 行业领域
 */
export enum INDUSTRY{
    集成电路 = 1,
    生物医药,
    人工智能及智能制造,
    航空航天,
    汽车产业,
    软件和信息服务业,
    低碳环保及新材料,
    综合,
    文化创意
}


/**更新状态 */
export enum UPDATESTATE {
    未填报 = 1,
    已填报 = 2
}


/**
 * 管理后台导出
 */
export enum OUTPUTTYPE {
    当前数据 = 1,
    全部数据
}


/**
 * 管理后台导出数据类型
 */
export enum OUTPUTDATATYPE {
    基本信息=1,
    月度出租率,
    在孵企业,
    融资企业
}


/**
 * 最高学历
 */
export enum DEGREE {
    本科 = 1,
    硕士,
    博士
}

/**
 * 性别
 */
export enum SEX {
    男 = 1,
    女
}


/**
 * 融资轮次
 */
export enum FINANCINGROUNDS {
    种子轮 = 1,
    天使投资,
    A轮,
    B轮,
    C轮,
    C轮以上,
}


/**
 * 孵化状态
 */
export enum FUHUASTATE {
    实体孵化 = 2,
    虚拟孵化 = 3,
    迁出= 4
}

/**入孵状态  只用于前端*/
export enum INSIDESTATE {
    全部 = 1,
    实体孵化,
    虚拟孵化,
}


/**
 * 虚拟孵化原因
 */
export enum VIRTUALCAUSE{
    政策服务 = 1,
    融资服务,
    研发服务,
    市场对接,
    技术对接,
    其他,
}


/**
 * 迁出类型
 */
export enum MOVEOUTTYPE{
    企业注销 = 1,
    非毕业迁出,//2.3修改
    毕业迁出,//2.3修改
    // 迁出孵化器_仍在张江,
    // 迁出张江_仍在浦东,
    // 迁出浦东_仍在上海,
    // 迁出上海,
    // 毕业迁出,//2.1新加
}

/**
 * 迁出去向
 * 2.3新加
 */
export enum MOVEOUTTRACE {
    迁出孵化器_仍在张江 = 1,
    迁出张江_仍在浦东,
    迁出浦东_仍在上海,
    迁出上海
}


/**
 * 非毕业迁出原因
 * 2.3
 */
export enum MOVEOUTCAUSENOTCLIENT {
    政策不给力 = 1,
    人才需求不足,
    经营成本过高_场地成本或人员成本_,
    办公空间拓展_无合适办公空间_,
    产业环境不足,
    企业孵化到期,
    其他
}


/**
 * 毕业迁出原因
 * 2.3
 */
export enum MOVEOUTCAUSECLIENT {
    认定高新企业 = 8,
    认定专精特新,
    累计融资超500万元,
    年营业收超1000万元
}


/**
 * 迁出原因
 * 2.3
 */
export enum MOVEOUTCAUSE {
    政策不给力 = 1,
    人才需求不足,
    经营成本过高_场地成本或人员成本_,
    办公空间拓展_无合适办公空间_,
    产业环境不足,
    企业孵化到期,
    其他,
    认定高新企业 = 8,
    认定专精特新,
    累计融资超500万元,
    年营业收超1000万元
}


// /**
//  * 迁出原因
//  */
// export enum MOVEOUTCAUSE{
//     政策不给力 = 1,
//     人才需求不足,
//     经营成本过高_场地成本或人员成本_,
//     办公空间拓展_无合适办公空间_,
//     产业环境不足,
//     企业孵化到期,
//     其他,
//     认定高新企业 = 7,//2.1加入 选择毕业迁出之后
//     认定专精特新,
//     累计融资超500万元,
//     年营业收超1000万元
// }



// /**
//  * 迁出原因 前端用 不包含 毕业原因
//  */
// export enum MOVEOUTCAUSE_CLIENT{
//     政策不给力 = 1,
//     人才需求不足,
//     经营成本过高_场地成本或人员成本_,
//     办公空间拓展_无合适办公空间_,
//     产业环境不足,
//     其他
// }

// /**
//  * 毕业原因
//  * 2.1新加
//  */
// export enum GRADUATECAUSE {
//     认定高新企业 = 7,//2.1加入 选择毕业迁出之后
//     认定专精特新,
//     累计融资超500万元,
//     年营业收超1000万元
// }


/**
 * 得分途径
 */
export enum SCOREWAYS {
    我的信息 = 1,
    我的数据,
    我的企业数据,
    任务得分
}


/**
 * 分数变化方式
 */
export enum CHANGEMODE {
    增加 = 1,
    减少
}


/**
 * 验证码类型
 */
export enum CODETYPE {
    修改密码 = 1,
}


/**
 * 短信类型
 */
export enum SMSTYPE {
    修改密码 = 1,
    信息填报提醒,
    创建孵化器提醒
}


/**
 * 企业申报数据类型表
 */
export enum ENTERPRISEDECLARATIONTYPE {
    经营状况 = 1,
    团队信息
}


/**
 * 上市情况
 */
export enum LISTINGSITUATION {
    A股 = 1,
    科创板,
    海外,
}


/**
 * 经营数据类型
 */
export enum BUSINESSDATATYPE {
    营业收入 = 1,
    研发投入,
    纳税
}


/**
 * 状态
 */
export enum STATEENUM {
    未选 = 1,
    是,
    否
}