/**
 * 小程序端 孵化器入口 审核相关
 * 作者: lxm
 * 
 */

import moment = require("moment");
import { findBusinessDataByParams, findBusinessDataByTimeAndUscc } from "../../../data/enterprise/businessdata";
import { ENTERPRISEDECLARATIONTYPE } from "../../../config/enum";
import { findTeamDataByParams, findTeamDataByUsccAndTime } from "../../../data/enterprise/team";
import { eccEnumValue } from "../../../util/verificationEnum";
import { eccFormParam } from "../../../util/verificationParam";
import { FuHuaQiReplenishEnterpriseBusinessDataConfig, FuHuaQiReplenishEnterpriseTeamDataConfig } from "../../../config/eccFormParamConfig";
import { BizError } from "../../../util/bizError";
import { ERRORENUM } from "../../../config/errorEnum";

function getCycle(cycleNumber:number) {
    if (!cycleNumber) return "-";
    let nameList = ["一", "二", "三", "四"];

    return `第${nameList[cycleNumber-1]}季度`;
}

/**
 * 待审核列表
 * @param uscc 孵化器统一信用代码
 */
export async function unauditedList(uscc:string) {
    let query = {fhqIsSubmit:false, fuHuaQiUscc:uscc};

    let businessDataList = await findBusinessDataByParams(query);

    let dataList = [];
    businessDataList.forEach(info => {
        let { name, quarter, isSubmit, year, isUpdate } = info;
        dataList.push({
            name,
            uscc:info.uscc,
            typeStr:"经营状况",
            type:ENTERPRISEDECLARATIONTYPE.经营状况,
            cycle:getCycle(quarter),
            quarter,
            year,
            enterpriseSubmit:isSubmit ? "是" : "否",
            isUpdate:isUpdate
        });
    });

    let teamDataList = await findTeamDataByParams(query);
    teamDataList.forEach(info => {
        let { name, quarter, isSubmit, year, isUpdate } = info;
        dataList.push({
            name,
            uscc:info.uscc,
            typeStr:"团队信息",
            type:ENTERPRISEDECLARATIONTYPE.团队信息,
            cycle:getCycle(quarter),
            quarter,
            year,
            enterpriseSubmit:isSubmit ? "是" : "否",
            isUpdate:isUpdate
        });
    });

    return { dataList };
}



/**
 * 已审核列表
 * @param uscc 孵化器统一信用代码
 * @param year 年度
 * @param quarter 季度
 */
export async function auditCompletedList(uscc:string, year:number, quarter:number) {
    let query = {fhqIsSubmit:true, fuHuaQiUscc:uscc, year:year, quarter:quarter};

    let businessDataList = await findBusinessDataByParams(query);

    let dataList = [];
    businessDataList.forEach(info => {
        let { name, quarter } = info;
        dataList.push({
            name,
            typeStr:"经营状况",
            cycle:getCycle(quarter),
        });
    });

    let teamDataList = await findTeamDataByParams(query);
    teamDataList.forEach(info => {
        let { name, quarter } = info;
        dataList.push({
            name,
            typeStr:"团队信息",
            cycle:getCycle(quarter),
        });
    });

    return { dataList };
}


/**
 * 孵化器补充企业数据
 * @param fuHuaQiUscc 孵化器统一信用代码
 * @param uscc 企业统一信用代码
 * @param type 类型
 * @param form 数据表单
 */
export async function fuHuaQiReplenishEnterpriseDataDeclaration(fuHuaQiUscc:string, uscc:string, type:number, year:number, quarter:number, form ) {
    eccEnumValue("孵化器补充企业数据", "type", ENTERPRISEDECLARATIONTYPE, type);

    if (type == ENTERPRISEDECLARATIONTYPE.团队信息) {
        eccFormParam("孵化器补充企业数据-团队信息", FuHuaQiReplenishEnterpriseTeamDataConfig, form);
        let teamInfo = await findTeamDataByUsccAndTime(uscc, year, quarter);
        if (teamInfo.fuHuaQiUscc != fuHuaQiUscc) {}
        for (let key in FuHuaQiReplenishEnterpriseTeamDataConfig) {
            teamInfo[key] = form[key];
        }
        await teamInfo.save();

    } else {
        eccFormParam("孵化器补充企业数据-经营状况", FuHuaQiReplenishEnterpriseBusinessDataConfig, form);
        let businessInfo = await findBusinessDataByTimeAndUscc(uscc, year, quarter);
        if (businessInfo.fuHuaQiUscc != fuHuaQiUscc) {}

        for (let key in FuHuaQiReplenishEnterpriseBusinessDataConfig) {
            businessInfo[key] = form[key];
        }
        await businessInfo.save();

    }
    
    return { isSuccess:true };
}


/**
 * 通过校验
 * @param fuHuaQiUscc 
 * @param uscc 
 * @param type 
 * @param year 
 * @param quarter 
 * @returns 
 */
export async function fuHuaQiPass(fuHuaQiUscc:string, uscc:string, type:number, year:number, quarter:number ) {
    eccEnumValue("孵化器补充企业数据", "type", ENTERPRISEDECLARATIONTYPE, type);

    let dataInfo:any = {};
    if (type == ENTERPRISEDECLARATIONTYPE.团队信息) {
        dataInfo = await findTeamDataByUsccAndTime(uscc, year, quarter);
    } else {
        dataInfo = await findBusinessDataByTimeAndUscc(uscc, year, quarter);
    }
    
    if (dataInfo.fhqIsSubmit) throw new BizError(ERRORENUM.重复通过填报数据, `${fuHuaQiUscc} 企业审核 重复通过`);

    dataInfo.fhqIsSubmit = true;
    await dataInfo.save();

    return { isSuccess:true };
}