/**
 * 小程序端 企业角色用户 逻辑
 * 作者:lxm
 * 3.0更新功能
 */

import { ERRORENUM } from "../../config/errorEnum";
import * as sysTools from "../../tools/system";
import { BizError } from "../../util/bizError";
import * as enterpriseData from "../../data/enterprise/enterprise";

/**
 * 企业登录
 * @param uscc 企业统一信用代码
 * @param pwd 
 */
export async function enterpriseLogin(uscc:string, pwd:string) {
    if (!sysTools.eccUscc(uscc)) throw new BizError(ERRORENUM.统一社会信用代码不合法, '孵化器登录时');

    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    if (!enterpriseInfo) throw new BizError(ERRORENUM.账号不存在);

    let checkPwd = sysTools.getPwdMd5(enterpriseInfo.uscc, pwd);
    if (enterpriseInfo.pwd != checkPwd) throw new BizError(ERRORENUM.密码错误);

    const Token = sysTools.getToken(uscc);
    
    let userInfo = {
        uscc: enterpriseInfo.uscc,
        // name: fuhuaqiInfo.name,
        firstLogin : !enterpriseInfo.firstLoginIsChangePwd,
        token:Token
    };

    enterpriseInfo.token = Token;
    enterpriseInfo.tokenMs = new Date().valueOf();

    await enterpriseInfo.save();
    
    return userInfo;
}


/**
 * 首次登录修改密码
 * @param uscc 企业统一信用代码
 * @param pwd 密码
 * @param confirmPwd 确认密码 
 */
export async function firstChangePwd(uscc:string, pwd:string, confirmPwd:string) {
    if (pwd != confirmPwd) throw new BizError(ERRORENUM.密码不一致);
    if (pwd.search(/^[A-Za-z0-9]{6,18}$/) < 0) throw new BizError(ERRORENUM.密码只能由6至18位字符和数字组成);

    let dataBaseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    if (dataBaseInfo.firstLoginIsChangePwd) throw new BizError(ERRORENUM.不能重复修改密码, `重复调用了首次登录之后的修改密码接口${uscc}`);

    dataBaseInfo.pwd = sysTools.getPwdMd5(uscc, sysTools.md5PwdStr(pwd));
    dataBaseInfo.firstLoginIsChangePwd = true;
    await dataBaseInfo.save();

    return {isSuccess:true};
}




/**
 * 找回密码 
 * todo  有问题， 企业没有负责人
 * @param phone 负责人电话号码  如果和库里的对不上 就要报错
 * @param uscc 企业统一信用代码
 * @param code 验证码
 * @param pwd 密码
 * @param confirmPwd 确认密码 
 */
export async function resettingPwd(phone:string, uscc:string, code:string, pwd:string, confirmPwd:string) {
    // if (!sysTools.eccUscc(uscc)) throw new BizError(ERRORENUM.统一社会信用代码不合法, '重置密码时');
    // let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    // if (!enterpriseInfo) throw new BizError(ERRORENUM.账号不存在, `重置密码时 uscc:${uscc}`);
    // if ( phone != fuHuaQiInfo.personInChargePhone) throw new BizError(ERRORENUM.号码与主体不一致, '修改密码发验证码时');
    // if (pwd != confirmPwd) throw new BizError(ERRORENUM.密码不一致);
    // if (pwd.search(/^[A-Za-z0-9]{6,18}$/) < 0) throw new BizError(ERRORENUM.密码只能由6至18位字符和数字组成);

    // let todayMs = sysTools.getTodayMs();
    // let codeList = await codeData.findTodayCodeByUscc(uscc, todayMs);

    // let now = new Date().valueOf();

    // let codeId = '';
    // let msg = ERRORENUM.验证码错误;
    // codeList.forEach(info => {
    //     if (info.code == code) {
    //         if (info.isUse) msg = ERRORENUM.验证码失效;
    //         else if ( (now - info.sendMs) > (30 * 60 * 1000) ) msg = ERRORENUM.验证码过期
    //         else codeId = info.id;
    //     }
    // });

    // if (!codeId) throw new BizError(msg, `uscc:${uscc}重置密码的code:${code}`);

    // await codeData.updateCodeState(codeId);

    // fuHuaQiInfo.pwd = sysTools.getPwdMd5(uscc, sysTools.md5PwdStr(pwd));

    // await fuHuaQiInfo.save();

    // return {isSuccess:true};
}