/**
 * 管理后台 月度任务相关
 * 作者:lxm
 */

import { ERRORENUM } from "../../../config/errorEnum";
import { BizError } from "../../../util/bizError";
import * as monthData from "../../../data/fuHuaQi/monthTable";
import { findAllFuHuaQiOperationNameMap } from "../../../data/fuHuaQi/fuhuaqi";
import { OUTPUTTYPE } from "../../../config/enum";


/**
 * 月度出租率数据列表
 * @param state 填报状态
 * @param year 数据年份
 * @param month 数据月份
 * @param page 页面
 */
export async function monthTableList(state:number, year:number, month:number, page:number) {
    let selectParam:any = {};
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);
    if (state == 2 || state == 3) {
        selectParam.draftLock = state == 2 ? true : false;
    }
    if (year) selectParam.year = year;
    if (month) selectParam.month = month;

    let dataBaseList = await monthData.findMonthTableListToPage(selectParam, (page-1)*10 );
    let count = await monthData.findMonthTableListCount(selectParam);

    let operationNameMap = await findAllFuHuaQiOperationNameMap();

    let dataList = [];
    dataBaseList.forEach( info => {
        let onceInfo = {
            operationName:operationNameMap[info.fuHuaQiUscc] || '',
            state:info.draftLock==false?'未填报':'已填报',
            time:`${info.year}年${info.month}月`,
            occupancyRate:info.occupancyRate ||  '-'
        };
        dataList.push(onceInfo);
    });

    return {count, dataList}
}


/**
 * 导出月度出租率数据列表
 * @param state 填报状态
 * @param year 数据年份
 * @param month 数据月份
 * @param page 页面
 */
export async function outPutMonthTableList(state:number, year:number, month:number, type:number) {
    let selectParam:any = {};
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);
    if (type == OUTPUTTYPE.当前数据 ) {
        if (state == 2 || state == 3) {
            selectParam.draftLock = state == 2 ? true : false;
        }
        if (year) selectParam.year = year;
        if (month) selectParam.month = month;
    }
  

    let dataBaseList = await monthData.findMonthTableList(selectParam);
    let operationNameMap = await findAllFuHuaQiOperationNameMap();

    let keyList = [ "operationName", "state", "time", "occupancyRate"];
    let titleList = [ "运营机构名称","填报状态","数据月份","出租率(%)"];
    let dataList = [titleList];
    dataBaseList.forEach( info => {
        let onceInfo = {
            operationName:operationNameMap[info.fuHuaQiUscc],
            state:info.draftLock==false?'未填报':'已填报',
            time:`${info.year}年${info.month}月`,
            occupancyRate:info.occupancyRate ||  '-'
        };

        let subList = [];
        keyList.forEach(subInfo => {
            subList.push(onceInfo[subInfo] || '');
        });
        dataList.push(subList);
    });


    return dataList;
}