/**
 * 
 * @param keyList 要生成的键名称集合 例如: ["键1", "键2"]
 * @param valLen 要生成的值的长度 例如 十位数就传1 百位数就传2  例如: 1  则会生成 键1或键2 的数据是1-10的随机数 
 * @param haveUnit 单位信息： 如果传 % 号则会把生成的随机数再求百分比 传false 则不生成单位  传 数组 例如：["家","个"] 则 键1的单位是 家， 键2的单位是个
 * @param title 数据标题
 * @param subTitle  数据副标题
 * @param total 是否要求和 
 * @returns 
 */
export function mock键值数据模板(keyList, valLen, haveUnit, title, subTitle, total) {
    let data = {
        "title": "",
        "subTitle": "",
        "total": 0,
        "list": []
    };
    if (title) data.title = title;
    if (subTitle) data.subTitle = subTitle || title;
    if ( haveUnit && haveUnit == "%" ) {
        let random = Math.ceil(  Math.random() * 20 );
        let avg = Math.ceil((100 - random) / keyList.length);
        keyList.forEach((key, index) => {
            let valut = index == 0 ? avg + random : avg;
            let onceInfo:any = {
                "key":key,
                "value": valut,
                unit:"%"
            };
            data.list.push(onceInfo);
        });

    } else {
        let unitIndex = 0;
        for (let i = 0; i < keyList.length; i++) {
            let key = keyList[i];
            let onceInfo:any = {
                "key":key,
                "value": getValueByLength(valLen)
            };
            if (haveUnit) {
                if (typeof haveUnit == "string") onceInfo.unit = haveUnit;
                else onceInfo.unit = haveUnit[unitIndex];
            }
            data.list.push(onceInfo);
            unitIndex += 1;
        }
    
        if (total) {
            data.list.forEach(keyValue=>{
                data.total += keyValue.value;
            })
        }
    }
    return data;
}

//键值数据 值为字符串
export function mock键值数据字符串模板(title, subTitle, obj) {
    let data = { title: "", subTitle: "", total: 0, list: [] };
    if (title) data.title = title;
    if (subTitle) data.subTitle = subTitle || title;
    for (let key in obj) {
        data.list.push({
            key,
            value:obj[key]
        });
    }

    return data;
}

//列表数据 obj:{ "表格1":{title1:1, title2:2, title3:3... } }
export function mock列表模板( obj, number ) {
    let tableNumber = Object.keys(obj).length;
    if (tableNumber > 1) {
        let data = [];
        for (let key in obj) {
            let onceTable:any = {title:key, total:number, subTitle:key, titleList:[], valueList:[] };
            onceTable.titleList = Object.keys(obj[key]);
            for (let i = 0; i < number; i++) {
                onceTable.valueList.push(Object.values(obj[key]) );
            }
    
            data.push(onceTable);
        }
        return data;
    } else {
        let onceTable:any = {};
        for (let key in obj) {
            onceTable = {title:key, total:number, subTitle:key, titleList:[], valueList:[] };
            onceTable.titleList = Object.keys(obj[key]);
            for (let i = 0; i < number; i++) {
                onceTable.valueList.push(Object.values(obj[key]) );
            }
    
        }
        return onceTable;
    }
   
}

export function mock图形数据模板(keyList, title, number?, subTitleList?) {
    if (!number) number = 1;
   
    if (number == 1) {
        let data = {
            "title": title ? title : "测试标题",
            "yMaxValue": 100,
            "yMinValue": 0,
            "yStepValue": 10,
            "unit": "个",
            "data": {
                "title": "测试数据标题",
                "subTitle": "测试数据副标题",
                "total": 1,
                "list": []
            }
        }
        for (let i = 0; i < keyList.length; i++) {
            let key = keyList[i];
            let onceInfo:any = {
                key,
                "value": Math.floor(Math.random()*99+1),
                "unit": "个"
            };
            
            data.data.list.push(onceInfo)
        }
    
        data.data.list.forEach(keyValue=>{
            data.data.total += keyValue.value;
        });
        return data;
    } else {
        let data = {
            "title": title ? title : "测试标题",
            "yMaxValue": 100,
            "yMinValue": 0,
            "yStepValue": 10,
            "unit": "个",
            "data": []
        };
        for (let y = 0; y < number; y++) {
            let onceData = {
                "title": subTitleList[y],
                "subTitle": subTitleList[y],
                "total": 1,
                "list": []
            }
            for (let i = 0; i < keyList.length; i++) {
                let key = keyList[i];
                let onceInfo:any = {
                    key,
                    "value": Math.floor(Math.random()*99+1),
                    "unit": "个"
                };
                
                onceData.list.push(onceInfo)
            }
        
            onceData.list.forEach(keyValue=>{
                onceData.total += keyValue.value;
            });
            data.data.push(onceData);
        }
       
        return data;
    }

}

// 柱状图数据模板 模拟数据
export function mock柱状图数据模板(len, title?) {
    let data = {
        "title": title ? title : "测试标题",
        "yMaxValue": 100,
        "yMinValue": 0,
        "yStepValue": 10,
        "unit": "个",
        "data": {
            "title": "测试数据标题",
            "subTitle": "测试数据副标题",
            "total": 1,
            "list": [
              
            ]
        }
      }
    
    for (let i = 0; i < len; i++) {
        let onceInfo:any = {
            "key": 2010 + i,
            "value": Math.floor(Math.random()*99+1),
            "unit": "个"
        };
        
        data.data.list.push(onceInfo)
    }

    data.data.list.forEach(keyValue=>{
        data.data.total += keyValue.value;
    })

    return data;
}

export function mock多柱柱状数据模板(len, 数组长度, title?) {
    let data = {
        "title": title ? title : "测试标题",
        "yMaxValue": 100,
        "yMinValue": 0,
        "yStepValue": 10,
        "unit": "个",
        "data": []
      }
    
    for (let arrLen = 0; arrLen < 数组长度; arrLen++) {
        let obj = {
            "title": "测试数据标题",
            "subTitle": "测试数据副标题",
            "total": 0,
            "list": [
              
            ]
        }

        for (let i = 0; i < len; i++) {
            let onceInfo:any = {
                "key": 2010 + i,
                "value": Math.floor(Math.random()*99+1),
                "unit": "个"
            };
            
            obj.list.push(onceInfo)
        }
    
        obj.list.forEach(keyValue=>{
            obj.total += keyValue.value;
        });

        data.data.push(obj);
    }

    return data;
}

//获取特定长度的测试文字
export function getTestStrByLength(strLen, strType) {
    let testStr = ``;
    if (strType == 'c') {//中文
        if (strLen < 5) {
            testStr += `测试文本`.substring(0, strLen);
        } else {
            testStr += `测试`;
            getPlaByLength((strLen - 4), () => {
                testStr += '-';
            });
            testStr += `文本`
        }
    } else {//英文
        testStr += `te`;
        getPlaByLength((strLen - 4), () => {
            testStr += '-';
        });
        testStr += `st`
    }
    return testStr;
}
function getValueByLength(length) {
    let i = 1;
    getPlaByLength(length, () => {
        i= i * 10;
    });
    return Math.floor(Math.random() * i);
}

//获取特定长度的 占位符号
function getPlaByLength(num, callback) {
    for (let i =0; i < num; i++) {
        callback();
    }
}



// 地图数据模板 模拟数据
export function mock地图数据模板(len) {
    let data = {
        "typeNameList": [
          "type1","type2","type3"
        ],
        "list": [
          
        ]
    }

    for (let i = 0; i < len; i++) {
        data.list.push({
            "x": Math.floor(Math.random()*500),
            "y": Math.floor(Math.random()*500),
            "typeName": "type"+(i%3+1),
            "title": "测试标题",
            "address": "测试地址",
            "data": "测试数据<b>加粗</b></br>等等"
          })
    }

    return data;
}

export function mock表数据模板(表头长度, 数据长度) {
    let data = {
        title:"",
        titleList:[],
        valueList:[]
    }

    for (let i = 0; i < 表头长度; i++) {
        data.titleList.push("表头"+i);
    }

    for(let j = 0; j < 数据长度; j++) {
        for (let i = 0; i < 表头长度; i++) {
            data.titleList.push("数据"+i);
        }
    }
}

export function randomNumber(max, min=0) {
    return Math.floor(Math.random()*(max-min))+min;
}