import mongoose = require('mongoose');

let defaultOptions = {
    useNewUrlParser:true,
    auto_reconnect:true,
    // reconnectTries:1000,
    // reconnectInterval:3000,
    keepAlive: 1,
    connectTimeoutMS: 30000,
    useCreateIndex: true,
    useUnifiedTopology: true
  };


export async function createDbConnect(connectUrl:string, options?:object) {
    if (!connectUrl) throw new Error(`wrong connect url ${connectUrl}`);
    if (!options) options = defaultOptions;
    return await mongoose.createConnection(connectUrl, options).catch((err)=>{throw err});
}
