import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const fuHuaQiTaskSchema = new Schema({
    key: {type:Number,index: true},//名称
    fuHuaQiName:String,//任务所属孵化器名称
    
});

var fuHuaQiTaskModel;
export function initModel(){
    fuHuaQiTaskModel = baseDB.model('fuHuaQiTask', fuHuaQiTaskSchema);
}

/**
 * 通过统一信用代码获取孵化器信息
 * @param uscc 统一信用代码
 */
export async function findFuHuaQiByUSCC(uscc:string) {
    return await fuHuaQiTaskModel.findOne({uscc}).exec();
}

/**
 * 通过孵化器名称获取孵化器信息
 * @param name 孵化器名称
 */
export async function findFuHuaQiByName(name:string) {
    return await fuHuaQiTaskModel.findOne({name}).exec();
}