import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const fuHuaQiSchema = new Schema({
    name: {type:String,index: true},//名称
    pwd:String,//登录密码
    operationName:String,//运营名称
    uscc:{type:String, index: true},//统一信用代码
    logonTime:Number,//注册时间
    lv:Number,//孵化器级别
    identificationTime:Number,//认定时间
    industry:[Number],//领域
    institutionalNature:Number,//机构性质
    liaison:String,//联系人
    liaisonPhone:String,//联系电话
    personInCharge:String,//负责人
    personInChargePhone:String,//负责人联系电话
    personInChargeAdd:String//联系地址
});

var fuHuaQiModel;
export function initModel(){
    fuHuaQiModel = baseDB.model('fuhuaqi', fuHuaQiSchema);
}

/**
 * 通过统一信用代码获取孵化器信息
 * @param uscc 统一信用代码
 */
export async function findFuHuaQiByUSCC(uscc:string) {
    return await fuHuaQiModel.findOne({uscc}).exec();
}

/**
 * 通过孵化器名称获取孵化器信息
 * @param name 孵化器名称
 */
export async function findFuHuaQiByName(name:string) {
    return await fuHuaQiModel.findOne({name}).exec();
}