import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const enterpriseSchema = new Schema({
    name: {type:String,index: true},//企业名称
    uscc:{type:String, index: true},//统一信用代码
    logonTime:Number,//注册时间
    logonAdd:String,//注册地址
    operatingAdd:String,//经营地址
    isPhysicalPresence:{type:Boolean, default:true},//是否实地孵化
    industry:[Number],//领域
    financingAmount:Number,//融资金额(万元)
    investmentInstitutionsName:String,//投资机构名称
    timeToObtainInvestment:Number,//获得投资时间
    fuHuaQiInvestment:{type:Boolean, default:false},//孵化器是否投资
    fuHuaQiInvestmentAmount:Number,//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:Number,//孵化器投资方式
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
});

var enterpriseModel;
export function initModel(){
    enterpriseModel = baseDB.model('enterprise', enterpriseSchema);
}
