const path = require('path');
import * as fs from "fs";
import { BizError, SysError } from "../util/bizError";
import { analysisXml } from "../util/myXML";
import { SYSTEMERRORENUM } from "./errorEnum";
import { ServerConfig } from "../config/systemClass";
const os = require('os');

export let systemConfig =  new ServerConfig;

const ConfigName = "serverConfig.xml";
export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo:any = await analysisXml(configStr);
		if (!configInfo || !configInfo.config) throw new BizError('xml中无配置');
		else {
            
            let {port, mongodb } = configInfo.config;
            systemConfig.port = parseInt(port[0]);
            systemConfig.mongodbStr = mongodb[0]
            
		}
        
        console.log("config init success");

    } catch(err) {
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}
 
