
import { areaList } from "../config/area";
import { systemConfig } from "../config/serverConfig";
import { BizError } from "../util/bizError";
import { get } from "../util/request";

/**
 * 地址是否属于张江
 */
export async function addressIsInZJ(address) {
    /**使用百度地图获取经纬度 */
    let param = {
        address:address,
        output:"json",
        city:"上海市",
        // ak:"tXZNOtuhb3PJHwax0eb7DkgHP9Zh5QOb",
        ak:systemConfig.ak
    }
    let reuslt:any = await get("https://api.map.baidu.com/geocoding/v3/", param);
    if (reuslt.status != 0 || !reuslt.result.location) {
        new BizError("获取张江地址错误", reuslt.message, JSON.stringify(reuslt));
        return false;
    }
    let point = reuslt.result.location;//转换好的经纬度

    /**射线法判断是否属于各个范围 命中一个就返回true*/
    let isInside = false; 
    for (let k = 0; k < areaList.length; k++) {
        let polygon:any = areaList[k];//单个区域

        if(polygon[0].lat != polygon[polygon.length-1].lat || polygon[0].lng != polygon[polygon.length-1].lng) {
            polygon.push(polygon[0]);
        }

        isInside = itemIsPointInPolygon(point, polygon);
            
        if (isInside) break;
    }
    
    return isInside;  
}

export async function latLngInZJ(lat:number, lng:number) {
    let point = {lat, lng};
    /**射线法判断是否属于各个范围 命中一个就返回true*/
    let isInside = false; 
    for (let k = 0; k < areaList.length; k++) {
        let polygon:any = areaList[k];//单个区域

        if(polygon[0].lat != polygon[polygon.length-1].lat || polygon[0].lng != polygon[polygon.length-1].lng) {
            polygon.push(polygon[0]);
        }

        isInside = itemIsPointInPolygon(point, polygon);
            
        if (isInside) break;
    }

    return isInside; 
}

/**
 * 获取经纬度
 * @param address 
 * @param city 
 * @returns 
 */
export async function getAddressLatAndLng(address, city, uscc) {
    let param = {
        address:address,
        output:"json",
        city,
        ak:systemConfig.ak,
    }
    let reuslt:any = await get("https://api.map.baidu.com/geocoding/v3/", param);
    if (reuslt.status == 0) {
        return reuslt.result.location
    }
    console.log(uscc, "失败", JSON.stringify(reuslt));
    return {error:true, errMsg:reuslt.message||JSON.stringify(reuslt) };
}

// //使用射线法
// export function isPointInPolygon(point) {  
//     let isInside = false; 
//     for (let k = 0; k < areaList.length; k++) {
//         let polygon:any = areaList[k];//单个区域

//         if(polygon[0].lat != polygon[polygon.length-1].lat || polygon[0].lng != polygon[polygon.length-1].lng) {
//             polygon.push(polygon[0]);
//         }

//         isInside = itemIsPointInPolygon(point, polygon);
        
        
//         if (isInside) break;
//     }
    
  
//     return isInside;  
// } 

function itemIsPointInPolygon(point,pts){
    var N = pts.length;  //pts [{lat:xxx,lng:xxx},{lat:xxx,lng:xxx}]
    var boundOrVertex = true; //如果点位于多边形的顶点或边上，也算做点在多边形内，直接返回true
    var intersectCount = 0;//cross points count of x
    var precision = 2e-10; //浮点类型计算时候与0比较时候的容差
    var p1, p2;//neighbour bound vertices
    var p = point; //point {lat:xxx,lng:xxx}
 
    p1 = pts[0];//left vertex
    for(var i = 1; i <= N; ++i){//check all rays
        if((p.lat==p1.lat)&&(p.lng==p1.lng)){
           return boundOrVertex;//p is an vertex
        }
        p2 = pts[i % N];//right vertex
        if(p.lat < Math.min(p1.lat, p2.lat) || p.lat > Math.max(p1.lat, p2.lat)){//ray is outside of our interests
           p1 = p2;
           continue;//next ray left point
        }
        if(p.lat > Math.min(p1.lat, p2.lat) && p.lat < Math.max(p1.lat, p2.lat)){//ray is crossing over by the algorithm (common part of)
            if(p.lng <= Math.max(p1.lng, p2.lng)){//x is before of ray
               if(p1.lat == p2.lat && p.lng >= Math.min(p1.lng, p2.lng)){//overlies on a horizontal ray
                    return boundOrVertex;
               }
               if(p1.lng == p2.lng){//ray is vertical
                  if(p1.lng == p.lng){//overlies on a vertical ray
                       return boundOrVertex;
                   }else{//before ray
                      ++intersectCount;
                   }
               }else{//cross point on the left side
                    var xinters = (p.lat - p1.lat) * (p2.lng - p1.lng) / (p2.lat - p1.lat) + p1.lng;//cross point of lng
                    if(Math.abs(p.lng - xinters) < precision){//overlies on a ray
                        return boundOrVertex;
                    }
                    if(p.lng < xinters){//before ray
                       ++intersectCount;
                    }
               }
            }
        }else{//special case when ray is crossing through the vertex
            if(p.lat == p2.lat && p.lng <= p2.lng){//p crossing over p2
                var p3 = pts[(i+1) % N]; //next vertex
                if(p.lat >= Math.min(p1.lat, p3.lat) && p.lat <= Math.max(p1.lat, p3.lat)){//p.lat lies between p1.lat & p3.lat
                    ++intersectCount;
                }else{
                    intersectCount += 2;
                }
            }
         }
         p1 = p2;//next ray left point
    }
    if(intersectCount % 2 == 0){//偶数在多边形外
       return false;
    } else { //奇数在多边形内
       return true;
    }
};