/**
 * 总路由入口
 */

import * as publicRouters from './public';
import * as mobileClientEnterpriseRouters from './mobileClient/enterprise';
import * as myEnterpriseRouters from './mobileClient/myEnterprise';
import * as mobileClientFinancingRouters from './mobileClient/financing';
import * as mobileClientFuHuaQiRouters from './mobileClient/fuHuaQi';
import * as mobileClientMonthRouters from './mobileClient/month';
import * as mobileClientUserRouters from './mobileClient/user';
import * as mobileClientBusinessRouters from './mobileClient/business';
import * as institutionalNatureRouters from './mobileClient/institutionalNature';
import * as remindRouters from './mobileClient/remind';
import * as filesRouters from './admin/files';

import * as adminEnterpriseRouters from './admin/enterprise';
import * as adminFuHuaQiRouters from './admin/fuHuaQi';
import * as adminUserRouters from './admin/user';
import * as adminScoreRouters from './admin/score';
import * as adminTaskRouters from './admin/task';
import * as informationRouters from './admin/information';
import * as instituQualifyRouters from './admin/instituQualify';
import * as dataMaintenanceRouters from './admin/dataMaintenance';
import * as statsRouters from './admin/stats';

import * as provideRouters from './provide';

import * as enterpriseMobileBaseRouters from './enterpriseMobileClient/base';
import * as enterpriseMobileBusinessdataRouters from './enterpriseMobileClient/businessdata';
import * as enterpriseMobileDatadeclarationRouters from './enterpriseMobileClient/datadeclaration';
import * as enterpriseMobileUserRouters from './enterpriseMobileClient/user';
import * as enterpriseMobileFinancingRouters from './enterpriseMobileClient/financing';

import * as testABIRouters from "./mobileClient/testAbi";

import * as pointRouters from "./point";
import * as gptRouters from "./gpt/ai";

import * as adminLabelsRouters from './admin/labels';
import * as guanWeiHuiMobileClientRouters from './guanWeiHuiMobileClient/manange';
import * as guanWeiHuiMobileClientUserRouters from './guanWeiHuiMobileClient/user';

import * as dangJianRouters from './mobileClient/dangJian';

import * as checkDataRouters from './admin/checkData';
import * as zhulingRouter from './mobileClient/zhuling';
import * as visitRouter from './mobileClient/visit';
import * as gwhvisitRouter from './guanWeiHuiMobileClient/visit';
import * as qyvisitRouter from './enterpriseMobileClient/visit';
import * as activityRouter from './mobileClient/activity';
import * as adminActivityRouter from './admin/activity';

import * as portraitRouter from './admin/portrait';
import * as dataSyncRouter from './admin/dataSync';

export function setRouter(httpServer){
    /**下拉框等公用 路由 */
    publicRouters.setRouter(httpServer);
    /**小程序端 孵化器入口路由 */
    mobileClientEnterpriseRouters.setRouter(httpServer);
    myEnterpriseRouters.setRouter(httpServer);
    mobileClientFinancingRouters.setRouter(httpServer);
    mobileClientFuHuaQiRouters.setRouter(httpServer);
    mobileClientMonthRouters.setRouter(httpServer);
    mobileClientBusinessRouters.setRouter(httpServer);
    mobileClientUserRouters.setRouter(httpServer);
    institutionalNatureRouters.setRouter(httpServer);
    remindRouters.setRouter(httpServer);
    
    /**管理后台端 入口路由 */
    adminEnterpriseRouters.setRouter(httpServer);
    adminFuHuaQiRouters.setRouter(httpServer);
    adminUserRouters.setRouter(httpServer);
    adminScoreRouters.setRouter(httpServer);
    adminTaskRouters.setRouter(httpServer);
    informationRouters.setRouter(httpServer);
    filesRouters.setRouter(httpServer);
    instituQualifyRouters.setRouter(httpServer);
    dataMaintenanceRouters.setRouter(httpServer);
    statsRouters.setRouter(httpServer);
    
    /**系统维护 入口路由 */
    provideRouters.setRouter(httpServer);
    /**小程序企业端 入口路由 */
    enterpriseMobileBaseRouters.setRouter(httpServer);
    enterpriseMobileBusinessdataRouters.setRouter(httpServer);
    enterpriseMobileDatadeclarationRouters.setRouter(httpServer);
    enterpriseMobileUserRouters.setRouter(httpServer);
    enterpriseMobileFinancingRouters.setRouter(httpServer);
    /**abi接口 */
    testABIRouters.setRouter(httpServer);
    /**埋点接口 */
    pointRouters.setRouter(httpServer);

    /**gpt */
    gptRouters.setRouter(httpServer);

    /**标签系统 */
    adminLabelsRouters.setRouter(httpServer);
    
    /**管委会 */
    guanWeiHuiMobileClientRouters.setRouter(httpServer);
    guanWeiHuiMobileClientUserRouters.setRouter(httpServer);

    /**党建 */
    dangJianRouters.setRouter(httpServer);

    /**数据校验 */
    checkDataRouters.setRouter(httpServer);

    zhulingRouter.setRouter(httpServer);

    visitRouter.setRouter(httpServer);
    gwhvisitRouter.setRouter(httpServer);
    qyvisitRouter.setRouter(httpServer);
    activityRouter.setRouter(httpServer);
    adminActivityRouter.setRouter(httpServer);


    dataSyncRouter.setRouter(httpServer);
    portraitRouter.setRouter(httpServer);
}