/**
 * 私有路由  用于维护迭代过程中造成的缺失数据
 * 注意：需要保证每个路由都使用  checkInterior  中间件
 */

import * as asyncHandler from 'express-async-handler';
import * as provideBiz from '../biz/admin/provide';
import { checkInterior } from '../middleware/user';


export function setRouter(httpServer) {
    httpServer.post('/admin/provide/task/add12',checkInterior, asyncHandler(provideLastTask));//已经弃用
    httpServer.post('/admin/provide/enterprise/updatestate',checkInterior, asyncHandler(updateEnterpriseState));
    httpServer.post('/admin/provide/task/updatetaskyear',checkInterior, asyncHandler(updateTaskYear));
    httpServer.post('/admin/provide/task/initScore',checkInterior, asyncHandler(initScore));
    httpServer.post('/admin/provide/task/replenishtaskcount',checkInterior, asyncHandler(replenishTaskCount));
    /**2.1 */
    httpServer.post('/admin/provide/data/updateadd',checkInterior, asyncHandler(updateAddress));
    /**3.0 */
    httpServer.post('/admin/provide/enterprise/enterpriseinfo',checkInterior, asyncHandler(enterpriseInfo));

    /**补录数据  已完成 */
    httpServer.post('/admin/provide/basedata/inputdata',checkInterior, asyncHandler(inputData));
    httpServer.post('/admin/provide/basedata/inputenterprise202304data',checkInterior, asyncHandler(inputEnterprise202304Data));

    /**3.2 */
    httpServer.post('/admin/provide/enterprise/initpwd', checkInterior, asyncHandler(updateEnterprisePwd) );

    /**4.2 */
    httpServer.post('/admin/provide/enterprise/financing/industry', checkInterior, asyncHandler(addFinancingIndustry) );
    /**4.3 */
    // httpServer.post('/admin/provide/enterprise/bussiness/rep', checkInterior, asyncHandler(addBussinessData) );
  
    httpServer.post('/admin/provide/fuhuaqi/scort/change', checkInterior, asyncHandler(repairChangeScortData) );
    
    /**4.4 */
    httpServer.post('/admin/provide/fuhuaqi/scort/repairmonth', checkInterior, asyncHandler(repairChangeTaskScortTimeData) );
    /**4.4.1 */
    httpServer.post('/admin/provide/fuhuaqi/instituqualify/namechangetooperationname', checkInterior, asyncHandler(repairInstituQualifyNameChangeToOperationName) );
    /**修复分数 内网用  */
    httpServer.post('/admin/provide/fuhuaqi/scort/repair', checkInterior, asyncHandler(repairScoreData) );
    /**修复任务分数 */
    httpServer.post('/admin/provide/fuhuaqi/scort/correcttask', checkInterior, asyncHandler(correctFuHuaQiScore) );
    httpServer.post('/admin/provide/fuhuaqi/scort/correctmyenterprise', checkInterior, asyncHandler(correctFuHuaQiMyEnterpriseScore) );

    //批量操作
    httpServer.post('/admin/provide/fuhuaqi/scort/enterpriseoutanin', checkInterior, asyncHandler(enterpriseOutAnInRot) );
    httpServer.post('/admin/provide/fuhuaqi/scort/enterpriseoutandinmoverout', checkInterior, asyncHandler(enterpriseOutAndInMoverOutRot) );
    
    /**更新分数 */
    httpServer.post('/admin/provide/fuhuaqi/scort/updte2024scort', checkInterior, asyncHandler(updte2024scort) );
    httpServer.post('/admin/provide/fuhuaqi/scort/repair2024scort', checkInterior, asyncHandler(repairReset2024Score) );

    /**迁出91310115MA1K4TB91Q*/
    httpServer.post('/admin/provide/fuhuaqi/output/once/1', checkInterior, asyncHandler(outPutOnceEnterpriseFor91310115MA1K4TB91Q) );

    /**第一次企业数据清洗 */
    httpServer.post('/admin/provide/enterprise/etl1', checkInterior, asyncHandler(etlfirst) );
    
    /** */
    httpServer.post('/admin/provide/fuhuaqi/customtask/6', checkInterior, asyncHandler(customTaskAndTaskId) );
    
}

async function inputEnterprise202304Data(req, res) {
    await provideBiz.replaceInitEnberpriseData();
    res.success({isUsccess:true});
}

async function inputData(req, res) {
    await provideBiz.inputEnterpriseData();
    res.success({isUsccess:true});
}

/**
 * 手动发放一月份任务
 * 使用情况：1.0使用  已弃用
 * @param req 
 * @param res 
 */
async function provideLastTask(req, res) {
    await provideBiz.provideLastTask();
    res.success({isUsccess:true});
}


/**
 * 添加任务的年份字段  用于筛选数据 
 * 使用情况：2.0使用
 * @param req 
 * @param res 
 */
async function updateTaskYear(req, res) {
    await provideBiz.updateFuHuaQiTaskYear();
    res.success({isUsccess:true});
}


/**
 * 更新企业的状态为 在孵企业
 * 使用情况：2.0使用
 * @param req 
 * @param res 
 */
async function updateEnterpriseState(req, res) {
    await provideBiz.updateEnterpriseFuHuaState();
    res.success({isUsccess:true});
}


/**
 * 初始化所有孵化器分数
 * 使用情况：2.0使用
 * 备注：只能调用一次
 * @param req 
 * @param res 
 */
async function initScore(req, res) {
    await provideBiz.initScoreData();
    res.success({isUsccess:true});
}


async function replenishTaskCount(req, res) {
    await provideBiz.replenishTaskData();
    res.success({isUsccess:true});
}


async function updateAddress(req, res) {
    await provideBiz.updateAdd();
    res.success({isUsccess:true});
}

async function enterpriseInfo(req, res) {
    await provideBiz.updateEnterpriseDataInfo();
    res.success({isUsccess:true});
}

async function updateEnterprisePwd(req, res) {
    await provideBiz.initEnterprisePwd();
    res.success({isUsccess:true});
}

async function addFinancingIndustry(req, res) {
    await provideBiz.addFinancingIndustry();
    res.success({isUsccess:true});
}

/**未定 */
async function addBussinessData(req, res) {
    await provideBiz.addBussiness();
    res.success({isUsccess:true});
}


async function repairScoreData(req, res) {
    await provideBiz.repairScore();
    res.success({isUsccess:true});
}


async function repairChangeScortData(req, res) {
    await provideBiz.changeScoreLogByJson();
    res.success({isUsccess:true});
}

async function repairChangeTaskScortTimeData(req, res) {
    await provideBiz.changeTaskScortTimeData();
    res.success({isUsccess:true});
}


async function repairInstituQualifyNameChangeToOperationName(req, res) {
    await provideBiz.instituQualifyNameChangeToOperationName();
    res.success({isUsccess:true});
}


async function correctFuHuaQiScore(req, res) {
    await provideBiz.correctFuHuaQiScoreData();
    res.success({isUsccess:true});
}


async function correctFuHuaQiMyEnterpriseScore(req, res) {
    await provideBiz.correctFuHuaQiMyEnterpriseScoreData();
    res.success({isUsccess:true});
}


async function enterpriseOutAnInRot(req, res) {
    await provideBiz.enterpriseOutAnIn();
    res.success({isUsccess:true});
}

async function enterpriseOutAndInMoverOutRot(req, res) {
    await provideBiz.enterpriseOutAndInMoverOut();
    res.success({isUsccess:true});
}


async function updte2024scort(req, res) {
    await provideBiz.updteScortFor2024();
    res.success({isUsccess:true});
}

async function repairReset2024Score(req, res) {
    await provideBiz.repairResettingScore();
    res.success({isUsccess:true});
}

async function outPutOnceEnterpriseFor91310115MA1K4TB91Q(req, res) {
    await provideBiz.outPutOnceEnterprise91310115MA1K4TB91Q();
    res.success({isUsccess:true});
}

async function etlfirst(req, res) {
    await provideBiz.ETL();
    res.success({isUsccess:true});
}

async function customTaskAndTaskId(req, res) {
    await provideBiz.xiuFuCustomTask();
    res.success({isUsccess:true});
}