/**
 * 租赁管理
 */


import * as asyncHandler from 'express-async-handler';
import * as userBiz from '../../biz/mobileFuHuaQi/fuHuaQi/user';
import { eccReqParamater } from '../../util/verificationParam';
import { checkFuHuaQiToken } from '../../middleware/user';
import * as leaseBiz from '../../biz/mobileFuHuaQi/lease';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/zulin/home/stats', checkFuHuaQiToken, asyncHandler(zl_home_stats));
    httpServer.post('/fuhuaqi/zulin/home/list', checkFuHuaQiToken, asyncHandler(zl_home_list));
    httpServer.post('/fuhuaqi/zulin/home/select/list', checkFuHuaQiToken, asyncHandler(zl_home_select_list));
    httpServer.post('/fuhuaqi/zulin/update', checkFuHuaQiToken, asyncHandler(zl_update));
    httpServer.post('/fuhuaqi/zulin/info', checkFuHuaQiToken, asyncHandler(zl_info));
}


async function zl_home_stats(req, res) {
    const Uscc = req.headers.uscc;
    let result = await leaseBiz.zlHomeStatis(Uscc);
    res.success(result);
}


async function zl_home_list(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {enterpriseName:'String', htstats:"Object", stats:"Number", zjstats:"Number"}; 
    let {enterpriseName, htstats, stats, zjstats } = eccReqParamater(reqConf, req.body, ["enterpriseName", "htstats", "stats", "zjstats"]);

    let result = await leaseBiz.zlHomeList(Uscc, enterpriseName, htstats, stats, zjstats);
    res.success(result);
}


async function zl_home_select_list(req, res) {
    let reqConf = {type:'Number'}; 
    let {type} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    let result = await leaseBiz.zlHomeSelectList(Uscc, type);
    
    res.success(result); 
}

async function zl_info(req, res) {
     let reqConf = {uscc:'String'}; 
    let {uscc} = eccReqParamater(reqConf, req.body);

    let result = await leaseBiz.zlInfo(uscc);

    res.success(result);
}


async function zl_update(req, res) {
    let reqConf = {uscc:'String', param:"Object"}; 
    let {uscc, param } = eccReqParamater(reqConf, req.body);

    let result = await leaseBiz.zlUpdate(uscc, param);
    
    res.success(result);
}