/**
 * 企业走访
 * 
 */
import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkFuHuaQiToken } from '../../middleware/user';
import * as visitBiz from '../../biz/mobileFuHuaQi/visit';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/visit/demand/list', checkFuHuaQiToken, asyncHandler(visit_demand_list));//诉求列表
    httpServer.post('/fuhuaqi/visit/demand/list/enterpriseinfo', checkFuHuaQiToken, asyncHandler(visit_demand_enterpriseinfo));//单个企业诉求列表
    httpServer.post('/fuhuaqi/visit/demand/add', checkFuHuaQiToken, asyncHandler(visit_demand_add));//添加诉求
    httpServer.post('/fuhuaqi/visit/demand/delete', checkFuHuaQiToken, asyncHandler(visit_demand_delete));//删除诉求

    httpServer.post('/fuhuaqi/visit/statis/base', checkFuHuaQiToken, asyncHandler(visit_statis_base));
    httpServer.post('/fuhuaqi/visit/statis/typelist', checkFuHuaQiToken, asyncHandler(visit_statis_type_list));
    httpServer.post('/fuhuaqi/visit/calendar/statis', checkFuHuaQiToken, asyncHandler(visit_alendar_statis));
    httpServer.post('/fuhuaqi/visit/calendar/list', checkFuHuaQiToken, asyncHandler(visit_calendar_list));

    httpServer.post('/fuhuaqi/visit/add', checkFuHuaQiToken, asyncHandler(visit_add));
    httpServer.post('/fuhuaqi/visit/info', checkFuHuaQiToken, asyncHandler(visit_info));
    httpServer.post('/fuhuaqi/visit/update/state', checkFuHuaQiToken, asyncHandler(visit_update_state));
    
    httpServer.post('/fuhuaqi/visit/track/add', checkFuHuaQiToken, asyncHandler(visit_track_add));
     httpServer.post('/fuhuaqi/visit/track/list', checkFuHuaQiToken, asyncHandler(visit_track_list));
     
    httpServer.post('/fuhuaqi/visit/log/statis', checkFuHuaQiToken, asyncHandler(visit_log_statis));
    httpServer.post('/fuhuaqi/visit/log/list', checkFuHuaQiToken, asyncHandler(visit_log_list));
}


async function visit_statis_base(req, res) {
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitStatisBase(Uscc);
    res.success(userInfo);
}


async function visit_statis_type_list(req, res) {
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitStatisTypeList(Uscc);
    res.success(userInfo);
}



async function visit_demand_list(req, res) {
    let reqConf = {demand:'[Number]'};
    let {demand} = eccReqParamater(reqConf, req.body, ["demand"]);
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitDemandList(Uscc, demand);
    res.success(userInfo);
}


async function visit_demand_add(req, res) {
    let reqConf = {demand:'[Number]', uscc:'String', demandDesc:'String'};
    let {demand, uscc, demandDesc} = eccReqParamater(reqConf, req.body);
    const FHQUscc = req.headers.uscc;

    let userInfo = await visitBiz.visitDemandAdd(FHQUscc, uscc, demand, demandDesc);
    res.success(userInfo);
}

async function visit_demand_enterpriseinfo(req, res) {
    let reqConf = { uscc:'String', };
    let {uscc} = eccReqParamater(reqConf, req.body);
    const FHQUscc = req.headers.uscc;

    let userInfo = await visitBiz.visitDemandEnterpriseInfo(uscc);
    res.success(userInfo);
}

async function visit_demand_delete(req, res) {
    let reqConf = { id:'String', };
    let {id} = eccReqParamater(reqConf, req.body);

    let userInfo = await visitBiz.visitDemandDelete(id);
    res.success(userInfo);
}




async function visit_alendar_statis(req, res) {
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitAlendarStatis(Uscc);
    res.success(userInfo);
}


async function visit_calendar_list(req, res) {
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitCalendarList(Uscc);
    res.success(userInfo);
}



async function visit_add(req, res) {
    let reqConf = {param:"Object"};
    let {param} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitAdd(Uscc, param);
    res.success(userInfo);
}


async function visit_info(req, res) {
    let reqConf = {id:"String"};
    let {id} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitInfo(id);
    res.success(userInfo);
}




async function visit_update_state(req, res) {
    let reqConf = {id:"String", state:"Number"};
    let {id, state} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitUpdateState(id, state);
    res.success(userInfo);
}


async function visit_track_add(req, res) {
    let reqConf = {uscc:"String", c:"Number", content:"String"};
    let {uscc, trackType, content} = eccReqParamater(reqConf, req.body);
    const fhqUscc = req.headers.uscc;

    let userInfo = await visitBiz.visitTrackAdd(fhqUscc, uscc, trackType, content);
    res.success(userInfo);
}

async function visit_track_list(req, res) {
    let reqConf = { uscc:'String', };
    let {uscc} = eccReqParamater(reqConf, req.body);
    const FHQUscc = req.headers.uscc;

    let userInfo = await visitBiz.visitDemandEnterpriseInfo(uscc);
    res.success(userInfo);
}

async function visit_log_statis(req, res) {
    let reqConf = {year:"Number"};
    let {year} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitLogStatis(Uscc, year);
    res.success(userInfo);
}


async function visit_log_list(req, res) {
    let reqConf = {year:"Number"};
    let {year} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.visitLogList(Uscc, year);
    res.success(userInfo);
}

