import * as asyncHandler from 'express-async-handler';
import * as testAbiBiz from '../../biz/mobileFuHuaQi/fuHuaQi/testAbi';
import { checkInterior } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/testabi/avgoccupancyrate', checkInterior, asyncHandler(avgOccupancyRate));
    httpServer.post('/testabi/totalacreage', checkInterior, asyncHandler(acreageTotal));
    httpServer.post('/testabi/institutionalnature', checkInterior, asyncHandler(institutionalNature));
    httpServer.post('/testabi/lv', checkInterior, asyncHandler(lv));
    httpServer.post('/testabi/enterprisetotal', checkInterior, asyncHandler(enterpriseTotal));
}
 

async function avgOccupancyRate(req, res) {
    let avgOccupancyRate = await testAbiBiz.getAvgOccupancyRate();
    res.success(avgOccupancyRate);
}    


async function acreageTotal(req, res) {
    let acreageTotal = await testAbiBiz.getAcreageTotal();
    res.success(acreageTotal);
}


async function institutionalNature(req, res) {
    let institutionalNature = await testAbiBiz.getInstitutionalNature();
    res.success(institutionalNature);
}


async function lv(req, res) {
    let lv = await testAbiBiz.getlv();
    res.success(lv);
}


async function enterpriseTotal(req, res) {
    let enterpriseTotal = await testAbiBiz.getEnterpriseTotal();
    res.success(enterpriseTotal);
}