/**
 * 小程序端  孵化器入口  企业相关路由
 */

import * as asyncHandler from 'express-async-handler';
import * as myEnterpriseBiz from '../../biz/mobileFuHuaQi/enterprise/myEnterprise';
import * as keynoteBiz from '../../biz/mobileFuHuaQi/enterprise/keynote';
import { checkFuHuaQiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import { FUHUASTATE } from '../../config/enum';

export function setRouter(httpServer) {
    /**我的企业 */
    httpServer.post('/fuhuaqi/myenterprise/list', checkFuHuaQiToken, asyncHandler(myEnterpriseList));
    httpServer.post('/fuhuaqi/myenterprise/jsqy/list', checkFuHuaQiToken, asyncHandler(myJSEnterpriseList));
    

    httpServer.post('/fuhuaqi/myenterprise/moveoutlist', checkFuHuaQiToken, asyncHandler(myEnterpriseMoveOutList));
    httpServer.post('/fuhuaqi/myenterprise/info', checkFuHuaQiToken, asyncHandler(myEnterpriseInfo));
    httpServer.post('/fuhuaqi/myenterprise/update', checkFuHuaQiToken, asyncHandler(updateMyEnterpriseInfo));
    httpServer.post('/fuhuaqi/myenterprise/replenish/create', checkFuHuaQiToken, asyncHandler(replenishCreate));
    httpServer.post('/fuhuaqi/myenterprise/replenish/input', checkFuHuaQiToken, asyncHandler(replenishInPut));
    /**我的企业 修改 */
    httpServer.post('/fuhuaqi/myenterprise/update/physical', checkFuHuaQiToken, asyncHandler(updatePhysical));
    httpServer.post('/fuhuaqi/myenterprise/update/virtual', checkFuHuaQiToken, asyncHandler(updateVirtual));
    httpServer.post('/fuhuaqi/myenterprise/update/moveout', checkFuHuaQiToken, asyncHandler(updateMoveOut));
    /**4.2 */
    httpServer.post('/fuhuaqi/myenterprise/qualification/select', checkFuHuaQiToken, asyncHandler(myEnterpriseQualification));
    httpServer.post('/fuhuaqi/myenterprise/qualification/update', checkFuHuaQiToken, asyncHandler(updateEnterpriseQualification));
    httpServer.post('/fuhuaqi/myenterprise/teaminfo/select', checkFuHuaQiToken, asyncHandler(myEnterpriseTeamInfo));
    httpServer.post('/fuhuaqi/myenterprise/team/info', checkFuHuaQiToken, asyncHandler(myEnterpriseTeamInfo));
    httpServer.post('/fuhuaqi/myenterprise/team/update', checkFuHuaQiToken, asyncHandler(teamUpdate));
    httpServer.post('/fuhuaqi/myenterprise/businessdata/select', checkFuHuaQiToken, asyncHandler(myEnterpriseBusinessData));

    //重点企业
    httpServer.post('/fuhuaqi/keynote/dynamics/homelist', checkFuHuaQiToken, asyncHandler(keynote_dynamics_home_list));//动态
    httpServer.post('/fuhuaqi/keynote/dynamics/list', checkFuHuaQiToken, asyncHandler(keynote_dynamics_list));//未读
    httpServer.post('/fuhuaqi/keynote/dynamics/changestate', checkFuHuaQiToken, asyncHandler(keynote_dynamics_change));//未读
    httpServer.post('/fuhuaqi/keynote/dynamics/enterprise', checkFuHuaQiToken, asyncHandler(keynote_dynamics_enterprise));//企业动态
    httpServer.post('/fuhuaqi/keynote/list', checkFuHuaQiToken, asyncHandler(keynote_list));//企业列表
    httpServer.post('/fuhuaqi/keynote/add', checkFuHuaQiToken, asyncHandler(keynote_add));//添加企业
    httpServer.post('/fuhuaqi/keynote/del', checkFuHuaQiToken, asyncHandler(keynote_del));//取消重点企业
}


async function keynote_dynamics_home_list(req, res) {
    const Uscc = req.headers.uscc;

    let result = await keynoteBiz.keynoteDynamicsHomeList(Uscc);
    res.success(result);
}

async function keynote_dynamics_list(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {type: 'Number' };
    let { type } = eccReqParamater(reqConf, req.body);

    let result = await keynoteBiz.keynoteDynamicsList(Uscc, type);
    res.success(result);
}

async function keynote_dynamics_change(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {id: 'String' };
    let { id } = eccReqParamater(reqConf, req.body);

    let result = await keynoteBiz.changeReadState(id);
    res.success(result);
}

async function keynote_dynamics_enterprise(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await keynoteBiz.keynoteDynamicsEnterprise( uscc);
    res.success(result);
}

async function keynote_list(req, res) {
    let reqConf = {label: '[String]' , selectStr: 'String'};
    let { label, selectStr } = eccReqParamater(reqConf, req.body,["label", "selectStr"]);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await keynoteBiz.keynoteList( FuHuaQiUscc, selectStr, label);
    res.success(result);
}

async function keynote_add(req, res) {
      let reqConf = {uscc: 'String'};
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await keynoteBiz.changeEnterpriseFollow( uscc, true);
    res.success(result);
}


async function keynote_del(req, res) {
    let reqConf = {uscc: 'String'};
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await keynoteBiz.changeEnterpriseFollow( uscc, false);
    res.success(result);
}



/**
 * 关注企业
 * @param req 
 * @param res 
 */
async function guan_zhu(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;
    let result = await myEnterpriseBiz.guanZhu(uscc);
    res.success(result);
}


/**
 * 取消关注
 * @param req 
 * @param res 
 */
async function qu_xiao_guan_zhu(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;
    let result = await myEnterpriseBiz.quXiaoGuanZhu(uscc);
    res.success(result);
}


/**
 * 我的企业列表
 * 小程序端 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseList(req, res) {
    let reqConf = {name: 'String', state:"Number", page:"Number" };
    let { name, state, page } = eccReqParamater(reqConf, req.body, ["name"]);
    const Uscc = req.headers.uscc;
    let data = await myEnterpriseBiz.myEnterprise(Uscc, state, name, page);

    res.success(data);
}


async function myJSEnterpriseList(req, res) {
    let reqConf = {name: 'String', page:"Number" };
    
    let { name, page } = eccReqParamater(reqConf, req.body, ["name"]);
    const Uscc = req.headers.uscc;
    let data = await myEnterpriseBiz.myEnterpriseJS(Uscc, 1, name, page);

    res.success(data);
}



/**
 * 我的企业列表迁出列表
 * 小程序端 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseMoveOutList(req, res) {
    let reqConf = {name: 'String', page:"Number" };
    let { name, page } = eccReqParamater(reqConf, req.body, ["name"]);
    const Uscc = req.headers.uscc;
    let data = await myEnterpriseBiz.myEnterprise(Uscc, FUHUASTATE.迁出, name, page);

    res.success(data);
}


/**
 * 企业基本信息
 * 我的企业列表中的企业基本信息
 * 回显
 * 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseInfo(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;
    let result = await myEnterpriseBiz.getMyEnterpriseBaseInfo(FuHuaQiUscc, uscc);
    res.success(result);
}


/**
 * 修改企业孵化状态 修改为实体
 * 2.0
 * @param req 
 * @param res 
 */
async function updatePhysical(req, res) {
    let reqConf = {leasedArea: 'Number', uscc:"String" };
    let { leasedArea, uscc } = await eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updatePhysicalInfo(FuHuaQiUscc, uscc, leasedArea);

    res.success(result);
}


/**
 * 修改企业孵化状态 修改为虚拟
 * 2.0
 * @param req 
 * @param res 
 */
async function updateVirtual(req, res) {
    let reqConf = {virtualCause: 'Number', uscc:"String" , virtualCauseDes:"String"};
    let { virtualCause, uscc, virtualCauseDes} = await eccReqParamater(reqConf, req.body, ["virtualCauseDes"]);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updateVirtualInfo(FuHuaQiUscc, uscc, virtualCauseDes, virtualCause);

    res.success(result);
}


/**
 * 修改企业孵化状态 修改为迁出
 * 2.0
 * @param req 
 * @param res 
 */
async function updateMoveOut(req, res) {
    let reqConf = {moveOutType: 'Number', uscc:"String" , moveOutTrace:"Number", moveOutCause:"[Number]"};
    const skipList = ["moveOutTrace", "moveOutCause"];
    let { moveOutType, uscc, moveOutCause, moveOutTrace } = await eccReqParamater(reqConf, req.body, skipList);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updateMoveOutInfo(FuHuaQiUscc, uscc, moveOutType, moveOutTrace, moveOutCause);

    res.success(result);
}


/**
 * 修改我的企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function updateMyEnterpriseInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await myEnterpriseBiz.updateMyEnterpriseBaseInfo(Uscc, form);
    res.success(result);
}


/**
 * 补录 新注册企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function replenishCreate(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await myEnterpriseBiz.replenishMyEnterpriseCreateInfo(Uscc, form);
    res.success(result);
}


/**
 * 补录 新迁入企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function replenishInPut(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await myEnterpriseBiz.replenishMyEnterpriseInPutInfo(Uscc, form);
    res.success(result);
}


/**
 * 企业资质
 * 4.2
 * @param req 
 * @param res 
 */
async function myEnterpriseQualification(req, res) {
    let reqConf = {uscc:"String"};
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.getMyEnterpriseQualification(uscc);
    res.success(result);
}



async function updateEnterpriseQualification(req, res) {
    let reqConf = {intellectualPropertyParam:'Object', qualificationParam:'Object', uscc:"String" };
    let {qualificationParam, uscc, intellectualPropertyParam} = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.updateQualification(uscc, intellectualPropertyParam, qualificationParam);

    res.success(result);
}


/**
 * 企业团队
 * 4.2
 * @param req 
 * @param res 
 */
async function myEnterpriseTeamInfo(req, res) {
    let reqConf = {uscc:"String", year:"Number", quarter:"Number"};
    let { uscc, year, quarter } = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.getMyEnterpriseTeamInfo(uscc, year, quarter);
    res.success(result);
}

async function teamUpdate(req, res) {
    let reqConf = {uscc:"String", year:"Number", quarter:"Number", cycsrbj:"[Number]", form:"Object"};
    let { uscc, quarter, year, cycsrbj, form } = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.updateMyEnterpriseTeamInfo(uscc, quarter, year, cycsrbj, form);
    res.success(result);
}


/**
 * 经济状况
 * @param req 
 * @param res 
 */
async function myEnterpriseBusinessData(req, res) {
    let reqConf = {uscc:"String", year:"Number"};
    let { uscc, year } = eccReqParamater(reqConf, req.body);

    let result = await myEnterpriseBiz.getMyEnterpriseBusinessData(uscc, year);
    res.success(result);
}

