/**
 * 小程序端  孵化器入口  融资相关路由
 */

import * as asyncHandler from 'express-async-handler';
import * as financingBiz from '../../biz/mobileFuHuaQi/enterprise/financing';
import { checkFuHuaQiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/financing/create', checkFuHuaQiToken, asyncHandler(createFinancingInfo));
    httpServer.post('/fuhuaqi/financing/update', checkFuHuaQiToken, asyncHandler(updateFinancingInfo));
    httpServer.post('/fuhuaqi/financing/select', checkFuHuaQiToken, asyncHandler(selectEnterpriseFinancingInfo));
    httpServer.post('/fuhuaqi/financing/delete', checkFuHuaQiToken, asyncHandler(delEnterpriseFinancingInfo));
    /** */
    httpServer.post('/fuhuaqi/financing/enterprisenamelist', checkFuHuaQiToken, asyncHandler(getFinancingInfoByName)); // todo 路由名称不对
}


/**
 * 新建企业融资信息 
 * @param req 
 * @param res 
 */
async function createFinancingInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await financingBiz.createFinancingInfo(Uscc, form);
    res.success(result);
}


/**
 * 修改企业融资信息 
 * @param req 
 * @param res 
 */
 async function updateFinancingInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await financingBiz.updateFinancingInfo(Uscc, form);
    res.success(result);
}


/**
 * 查询企业融资信息 
 * 回显
 * @param req 
 * @param res 
 */
async function selectEnterpriseFinancingInfo(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FHQUscc = req.headers.uscc;

    let result = await financingBiz.getEnterpriseFinancingByUscc(FHQUscc, uscc);
    res.success(result);
}


/**
 * 删除企业融资草稿信息 
 * @param req 
 * @param res 
 */
async function delEnterpriseFinancingInfo(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FHQUscc = req.headers.uscc;

    let result = await financingBiz.deleteEnterpriseFinancingByUscc(FHQUscc, uscc);
    res.success(result);
}


/**
 * 根据融资企业名称获取融资企业名称 
 * @param req 
 * @param res 
 */
async function getFinancingInfoByName(req, res) {
    const Uscc = req.headers.uscc;
    
    let result = await financingBiz.getFuHuaQiEnterpriseForSelect(Uscc);
    res.success(result);
}
