/**
 * 小程序端  孵化器入口  党建表单
 */

import * as asyncHandler from 'express-async-handler';
import * as dangJianBiz from '../../biz/mobileFuHuaQi/fuHuaQi/dangJian';
import { checkFuHuaQiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/dangjian/zhongchuang/info', checkFuHuaQiToken, asyncHandler(infoZhongChuang));
    httpServer.post('/fuhuaqi/dangjian/zhongchuang/replenish', checkFuHuaQiToken, asyncHandler(replenishZhongChuang));
    httpServer.post('/fuhuaqi/dangjian/zaifu/info', checkFuHuaQiToken, asyncHandler(infoZaiFu));
    httpServer.post('/fuhuaqi/dangjian/zaifu/replenish', checkFuHuaQiToken, asyncHandler(replenishZaiFu));

}


async function infoZhongChuang(req, res) {
    const Uscc = req.headers.uscc;

    let result = await dangJianBiz.zhongChuangInfo(Uscc);
    res.success(result);
}


async function replenishZhongChuang(req, res) {

    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;
    let result = await dangJianBiz.replenishZhongChuang(Uscc, form);
    res.success(result);
}


async function infoZaiFu(req, res) {
    const Uscc = req.headers.uscc;

    let result = await dangJianBiz.zaiFuInfo(Uscc);
    res.success(result);
}


async function replenishZaiFu(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;
    let result = await dangJianBiz.replenishZaiFu(Uscc, form);
    res.success(result);
}




