/**
 *企业活动 
 */

import * as asyncHandler from 'express-async-handler';
import { checkFuHuaQiToken } from '../../middleware/user';
import * as activityBiz from '../../biz/mobileEnterprise/activity';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/activity/list', checkFuHuaQiToken, asyncHandler(activity_list));//活动列表
    httpServer.post('/fuhuaqi/activity/info', checkFuHuaQiToken, asyncHandler(activity_info));//活动详情
}

async function activity_list(req, res) {

    let userInfo = await activityBiz.activityList();
    res.success(userInfo);
}


async function activity_info(req, res) {
    let reqConf = {id:'String'};
    let {id} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let userInfo = await activityBiz.activityInfo(id);
    res.success(userInfo);
}

