/**
 * 管委会端
 */

import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkGuanWeiHuiMobileToken } from '../../middleware/user';
import * as visitBiz from '../../biz/mobileFuHuaQi/visit';

export function setRouter(httpServer) {
    httpServer.post('/guanweihui/visit/calendar/statis', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_alendar_statis));
    httpServer.post('/guanweihui/visit/calendar/list', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_calendar_list));
    httpServer.post('/guanweihui/visit/add', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_add));
    httpServer.post('/guanweihui/visit/info', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_info));
    httpServer.post('/guanweihui/visit/update/state', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_update_state));
    httpServer.post('/guanweihui/visit/log/statis', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_log_statis));
    httpServer.post('/guanweihui/visit/log/list', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_log_list));

    //首页
    httpServer.post('/guanweihui/visit/home/statis', checkGuanWeiHuiMobileToken, asyncHandler(gwh_visit_home_statis));//新加

    httpServer.post('/guanweihui/enterprisenamelist', checkGuanWeiHuiMobileToken, asyncHandler(getEnterprisenamelist)); // todo 路由名称不对
}


/**
 *  
 * @param req 
 * @param res 
 */
async function getEnterprisenamelist(req, res) {
    const Uscc = req.headers.uscc;
    
    let result = await visitBiz.getEnterpriseForSelect();
    res.success(result);
}


/**
 * 日历-统计
 * @param req 
 * @param res 
 */
async function gwh_visit_alendar_statis(req, res) {
    let reqConf = {year:"Number"};
    let {year} = eccReqParamater(reqConf, req.body);
    let userInfo = await visitBiz.gwhVisitAlendarStatis(year);
    res.success(userInfo);
}


async function gwh_visit_calendar_list(req, res) {
    let userInfo = await visitBiz.gwhVisitCalendarList();
    res.success(userInfo);
}


async function gwh_visit_add(req, res) {
    let reqConf = {param:"Object"};
    let {param} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.gwhvisitAdd(Uscc, param);
    res.success(userInfo);
}


async function gwh_visit_info(req, res) {
    let reqConf = {id:"String"};
    let {id} = eccReqParamater(reqConf, req.body);

    let userInfo = await visitBiz.gwhVisitInfo(id);
    res.success(userInfo);
}


async function gwh_visit_update_state(req, res) {
    let reqConf = {id:"String", state:"Number"};
    let {id, state} = eccReqParamater(reqConf, req.body);

    let userInfo = await visitBiz.visitUpdateState(id, state);
    res.success(userInfo);
}


async function gwh_visit_log_statis(req, res) {
    let reqConf = {year:"Number"};
    let {year} = eccReqParamater(reqConf, req.body);

    let userInfo = await visitBiz.gwhVisitLogStatis(year);
    res.success(userInfo);
}


async function gwh_visit_log_list(req, res) {
    let reqConf = {year:"Number"};
    let {year} = eccReqParamater(reqConf, req.body);

    let userInfo = await visitBiz.gwhVisitLogList( year);
    res.success(userInfo);
}

async function gwh_visit_home_statis(req, res) {
    let userInfo = await visitBiz.gwhVisitHomeStatis();
    res.success(userInfo);
    
}