/**
 * 小程序端  管委会  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as userBiz from '../../biz/mobileGuanWeiHui/user';
import { eccReqParamater } from '../../util/verificationParam';
import { checkGuanWeiHuiMobileToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/guanweihui/login', asyncHandler(login));
    httpServer.post('/guanweihui/logout', checkGuanWeiHuiMobileToken, asyncHandler(loginOut));
}



/**
 * 管理后台登录
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let userInfo = await userBiz.login(loginId, pwd);
    res.success(userInfo);
}

/**
 * 退出登录
 * @param req 
 * @param res 
 */
async function loginOut(req, res) {
    const userId = req.headers.userid;
    let result = await userBiz.logout(userId);
    res.success(result);
}


