/**
 * 小程序端  管委会  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseManageBaseBiz from '../../biz/mobileGuanWeiHui/enterpriseManage/base';
import * as fuHuaQiManageBaseBiz from '../../biz/mobileGuanWeiHui/fuHuaQiManage/base';
import * as fuHuaQiManageTaskBiz from '../../biz/mobileGuanWeiHui/fuHuaQiManage/task';
import * as homePageBiz from '../../biz/mobileGuanWeiHui/homePage';
import { eccReqParamater } from '../../util/verificationParam';
import { checkGuanWeiHuiMobileToken } from '../../middleware/user';


export function setRouter(httpServer) {
    httpServer.post('/guanweihui/enterprise/list', checkGuanWeiHuiMobileToken, asyncHandler(enterpriseList));
    httpServer.post('/guanweihui/enterprise/info', checkGuanWeiHuiMobileToken, asyncHandler(enterpriseInfo)); 

    httpServer.post('/guanweihui/fuhuaqi/list', checkGuanWeiHuiMobileToken, asyncHandler(fuHuaQiList));
    httpServer.post('/guanweihui/fuhuaqi/info', checkGuanWeiHuiMobileToken, asyncHandler(fuHuaQiInfo));

    httpServer.post('/guanweihui/fuhuaqi/task/tasklist', checkGuanWeiHuiMobileToken, asyncHandler(fuHuaQiTaskList));
    httpServer.post('/guanweihui/fuhuaqi/task/monthlist', checkGuanWeiHuiMobileToken, asyncHandler(fuHuaQiTaskMonthsList))

    httpServer.post('/guanweihui/homepage/info', checkGuanWeiHuiMobileToken, asyncHandler(homePageTop));
    httpServer.post('/guanweihui/homepage/enterpriselabel', checkGuanWeiHuiMobileToken, asyncHandler(getEnterpriseLabel));
    httpServer.post('/guanweihui/homepage/fuhuaqilabel', checkGuanWeiHuiMobileToken, asyncHandler(getFuHuaQiLabel));

}

async function enterpriseList(req, res) {
    let reqConf = {name:'String',  page:'Number', labelId:"String", year:"Number", month:"Number"};
    let {labelId, year, month, name, page} = eccReqParamater(reqConf, req.body, ["teams","labelId", "year", "month",]);
    
    let result = await enterpriseManageBaseBiz.enterpriseList(name, page, labelId, year, month);
    res.success(result);
}

async function enterpriseInfo(req, res) {
    let reqConf = {uscc:'String'};
    let {uscc} = eccReqParamater(reqConf, req.body);
    
    let result = await enterpriseManageBaseBiz.enterpriseInfomation(uscc);
    res.success(result);
}



async function fuHuaQiList(req, res) {
    let reqConf = {labelId:"String", name:'String', page:'Number'};
    let {name, page, labelId} = eccReqParamater(reqConf, req.body);
    
    let result = await fuHuaQiManageBaseBiz.fuHuaQiList(name, page, labelId);
    res.success(result);
}


async function fuHuaQiInfo(req, res) {
    let reqConf = {uscc:'String'};
    let {uscc} = eccReqParamater(reqConf, req.body);
    
    let result = await fuHuaQiManageBaseBiz.fuHuaQiInfomation(uscc);
    res.success(result);
}


async function fuHuaQiTaskList(req, res) {
    let reqConf = {
        type:'Number',
        subType:'Number',
        year:'Number', 
        month:'Number', 
        name:'String', 
        page:'Number'
    };
    let {type, year, month, name, page, subType} = eccReqParamater(reqConf, req.body, ["name", "subType"]);
    
    let result = await fuHuaQiManageTaskBiz.taskList(type, year, month, name, page, subType);
    res.success(result);
}

async function fuHuaQiTaskMonthsList(req, res) {
    let result = await fuHuaQiManageTaskBiz.taskMonthsList();
    res.success(result);
}


async function homePageTop(req, res) {
    let reqConf = {
        year:'Number',
        month:'Number'
    };
    let {year, month} = eccReqParamater(reqConf, req.body);
    
    let result = await homePageBiz.stagingHomePageTop(year, month);
    res.success(result);
}


async function getEnterpriseLabel(req, res) {
    let result = await homePageBiz.enterpriseLabel();
    res.success(result);
}


async function getFuHuaQiLabel(req, res) {
    let result = await homePageBiz.fuHuaQiLabel();
    res.success(result);
}