/**
 * 小程序端  孵化器入口  经营数据报表功能路由
 */

import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { aiChart, zjAiChart, generateReport } from '../../biz/gpt/report';
import { checkGuanWeiHuiToken } from '../../middleware/user';

export function setRouter(httpServer) {
    /**聊天 */
    httpServer.post('/fuhuaqi/gpt/chart', checkGuanWeiHuiToken, asyncHandler(chart));
    httpServer.post('/fuhuaqi/gpt/zjchart', checkGuanWeiHuiToken, asyncHandler(zJchart));
    httpServer.post('/fuhuaqi/gpt/doc', checkGuanWeiHuiToken, asyncHandler(doc));
}

async function chart(req, res) {
    let reqConf = {msg: 'String', messageList:'[Object]' };
    let { msg, messageList } = eccReqParamater(reqConf, req.body);
    const userId = req.headers.userid;
    let result = {};
    if (!req.headers.isFuHuaQi) {
        result = await aiChart(userId, msg, messageList);
    }
    
    res.success(result);
}

async function zJchart(req, res) {
    let reqConf = {msg: 'String' };
    let { msg } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;
    let result = {};
    if (!req.headers.isFuHuaQi) {
        result = await zjAiChart(msg);
    }
    res.success(result);
}

async function doc(req, res) {
    let result = {};
    if (!req.headers.isFuHuaQi) {
        result = await generateReport();
    }
    res.success(result);
}

