/**
 * 企业端的需求
 */

import * as asyncHandler from 'express-async-handler';
import { eccReqParamater } from '../../util/verificationParam';
import { checkEnterpriseToken } from '../../middleware/user';
import * as visitBiz from '../../biz/mobileFuHuaQi/visit';

export function setRouter(httpServer) {
    httpServer.post('/enterprise/visit/demand/list', checkEnterpriseToken, asyncHandler(visit_demand_list));//诉求列表
    httpServer.post('/enterprise/visit/demand/add', checkEnterpriseToken, asyncHandler(visit_demand_add));//添加诉求
}


async function visit_demand_list(req, res) {
    const Uscc = req.headers.uscc;

    let userInfo = await visitBiz.enterpriseVisitDemandList(Uscc);
    res.success(userInfo);
}


async function visit_demand_add(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {demand:'[Number]', demandDesc:'String'};
    let {demand, demandDesc} = eccReqParamater(reqConf, req.body);

    let userInfo = await visitBiz.enterpriseAddDemand(Uscc, demand, demandDesc);
    res.success(userInfo);
}
