/**
 * 小程序端  企业入口  融资相关接口
 */


import * as asyncHandler from 'express-async-handler';
import { checkEnterpriseToken } from '../../middleware/user';
import * as financingBiz from '../../biz/mobileEnterprise/financing';
import { eccReqParamater } from '../../util/verificationParam';

export function setRouter(httpServer) {
    httpServer.post('/enterprise/financing/list', checkEnterpriseToken, asyncHandler(financingList));
    httpServer.post('/enterprise/financing/add', checkEnterpriseToken, asyncHandler(addFinancing));
    httpServer.post('/enterprise/financing/info', checkEnterpriseToken, asyncHandler(financingInfo));
    httpServer.post('/enterprise/financing/update', checkEnterpriseToken, asyncHandler(updateFinancing));
    httpServer.post('/enterprise/financing/del', checkEnterpriseToken, asyncHandler(deleteFinancing));
}


/**
 * 融资列表
 * @param req 
 * @param res 
 */
async function financingList(req, res) {
    const Uscc = req.headers.uscc;

    let result = await financingBiz.getEnterpriseFinancingList(Uscc);

    res.success(result);
}


/**
 * 添加融资信息
 * @param req 
 * @param res 
 */
async function addFinancing(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let {form} = eccReqParamater(reqConf, req.body);

    let result = await financingBiz.addEnterpriseFinancing(Uscc, form);

    res.success(result);
}


/**
 * 回显融资信息
 * @param req 
 * @param res 
 */
async function financingInfo(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {id:'String'};
    let {id} = eccReqParamater(reqConf, req.body);

    let result = await financingBiz.getEnterpriseFinancingInfo(Uscc, id);

    res.success(result);
}


/**
 * 修改融资信息
 * @param req 
 * @param res 
 */
async function updateFinancing(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let {form} = eccReqParamater(reqConf, req.body);

    let result = await financingBiz.updateEnterpriseFinancingInfo(Uscc, form);

    res.success(result);
}


/**
 * 删除融资信息
 * @param req 
 * @param res 
 */
async function deleteFinancing(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {id:'String'};
    let {id} = eccReqParamater(reqConf, req.body);

    let result = await financingBiz.deleteEnterpriseFinancingInfo(Uscc, id);

    res.success(result);
}