/**
 * 任务中心路由
 */

import * as asyncHandler from 'express-async-handler';
import * as customTaskBiz from '../../biz/admin/fuHuaQi/customTask';
import * as taskBiz from '../../biz/admin/fuHuaQi/task';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';


export function setRouter(httpServer) {
    httpServer.post('/admin/task/financingtasklist',checkGuanWeiHuiToken, asyncHandler(getFinancingTaskList));
    httpServer.post('/admin/task/enterprisetasklist',checkGuanWeiHuiToken, asyncHandler(getEnterpriseTaskList));
    httpServer.post('/admin/task/businesstasklist',checkGuanWeiHuiToken, asyncHandler(businessTaskList));
    /**导出 */
    httpServer.post('/admin/data/output/financingtasklist',checkGuanWeiHuiToken, asyncHandler(outPutFinancingTask));
    httpServer.post('/admin/data/output/enterprisetasklist',checkGuanWeiHuiToken, asyncHandler(outPutEnterpriseTaskList));
    httpServer.post('/admin/data/output/businesstasklist',checkGuanWeiHuiToken, asyncHandler(outPutQBusinessTaskList));

    /**自定义任务 */
    httpServer.post('/admin/task/customtask/fuhuaqi/list', checkGuanWeiHuiToken, asyncHandler(customTaskList));
    httpServer.post('/admin/task/customtask/fuhuaqi/add', checkGuanWeiHuiToken, asyncHandler(addCustomTask));
    httpServer.post('/admin/task/customtask/fuhuaqi/recovery', checkGuanWeiHuiToken, asyncHandler(recoveryCustomTask));
    httpServer.post('/admin/task/customtask/fuhuaqi/changecycle', checkGuanWeiHuiToken, asyncHandler(changeCustomTaskCycle));
}


async function getFinancingTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        page: 'Number' 
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await taskBiz.financingTaskList(state, time, page);

    res.success(result);
}


async function getEnterpriseTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        page: 'Number' 
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await taskBiz.addEnterpriseTaskList(state, time, page);

    res.success(result);
}


async function outPutFinancingTask(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        type:'Number',//下载类型
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys); 
    let {dataList, name} = await taskBiz.outPutFinancingTaskList(state, time, type);

    let fileName = `孵化器${name}融资企业任务列表.xlsx`;

    res.success({name:fileName, data:dataList});
}


async function outPutEnterpriseTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        type:'Number',//下载类型
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys); 
    let {dataList, name} = await taskBiz.outPutAddEnterpriseTaskList(state, time, type);

    let fileName = `孵化器${name}新迁入企业任务列表.xlsx`;

    res.success({name:fileName, data:dataList});
}


/**
 * 季度任务列表 
 * @param req 
 * @param res 
 */
async function businessTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        year: 'Number',//数据年
        quarter:'Number',//数据季度
        page: 'Number' 
    };
    const NotMustHaveKeys = ["state", "year", "quarter"];
    let {state, year, quarter, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await taskBiz.quarterTaskList(state, year, quarter, page);

    res.success(result);
}


/**
 * 导出季度任务数据
 * @param req 
 * @param res 
 */
async function outPutQBusinessTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        year: 'Number',//数据年
        quarter:'Number',//数据季度
        type: 'Number' 
    };
    const NotMustHaveKeys = ["state", "year", "quarter"];
    let {state, year, quarter, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let {dataList, name} = await taskBiz.outPutQuarterTaskDataList(type, state, year, quarter);

    let fileName = `孵化器${name}经营数据.xlsx`;
    res.success({name:fileName, data:dataList});
}


async function customTaskList(req, res) {
    let reqConf = {
        fuHuaQiTaskType:'Number',
        dataCycle:'Number', 
        pageNumber:'Number'
    };
    const NotMustHaveKeys = ["fuHuaQiTaskType", "dataCycle"];
    let { fuHuaQiTaskType, dataCycle, pageNumber } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await  customTaskBiz.taskList( fuHuaQiTaskType, dataCycle, pageNumber);

    res.success(result);
}


async function addCustomTask(req, res) {
    let reqConf = {
        fuHuaQiTaskType:'Number',
        dataCycle:'Number', 
        startMs:'Number',
        endMs:'Number'
    };
    const NotMustHaveKeys = [];
    let { fuHuaQiTaskType, dataCycle, startMs, endMs } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await customTaskBiz.createTask( fuHuaQiTaskType, dataCycle, startMs, endMs);

    res.success(result);
}


async function recoveryCustomTask(req, res) {
    let reqConf = {
        id:'String',
    };
    const NotMustHaveKeys = [];
    let { id } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await customTaskBiz.recovery(id);

    res.success(result);
}


async function changeCustomTaskCycle(req, res) {
    let reqConf = {
        id:'String',
        startMs:'Number',
        endMs:'Number'
    };
    const NotMustHaveKeys = [];
    let { id, startMs, endMs } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await customTaskBiz.changeCycle(id, startMs, endMs);

    res.success(result);
}