

import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as portraitBiz from '../../biz/admin/enterprise/enterprisePortrait';


export function setRouter(httpServer) {
    /** 标签管理*/
    httpServer.post('/admin/portrait/enterprise',checkGuanWeiHuiToken, asyncHandler(enterprisePortrait));
}


async function enterprisePortrait(req, res) {
    let reqConf = { uscc: 'String'};
    const NotMustHaveKeys = [];
    let {uscc} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await portraitBiz.portrait(uscc);

    res.success(result);
}