/**
 * 管理后台 标签路由
 */


import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as labelBiz from '../../biz/admin/labelMGT';
import * as fuHuaQiLabelBiz from '../../biz/admin/fuHuaQi/fuHuaQiLabel';
import * as enterpriseLabelBiz from '../../biz/admin/enterprise/enterpriseLabel';


export function setRouter(httpServer) {
    /** 标签管理*/
    httpServer.post('/admin/labels/list',checkGuanWeiHuiToken, asyncHandler(labList));
    httpServer.post('/admin/labels/add',checkGuanWeiHuiToken, asyncHandler(createLab));
    httpServer.post('/admin/labels/update',checkGuanWeiHuiToken, asyncHandler(updateLab));
    httpServer.post('/admin/labels/delete',checkGuanWeiHuiToken, asyncHandler(deleteLab));
    httpServer.post('/admin/labels/select',checkGuanWeiHuiToken, asyncHandler(labelSelect));
    /** 孵化器标签*/
    httpServer.post('/admin/labels/fuhuaqi/list',checkGuanWeiHuiToken, asyncHandler(fuHuaQiLabList));
    httpServer.post('/admin/labels/fuhuaqi/add',checkGuanWeiHuiToken, asyncHandler(addFuHuaQiLab));
    httpServer.post('/admin/labels/fuhuaqi/log',checkGuanWeiHuiToken, asyncHandler(fuHuaQiLabLog));
    httpServer.post('/admin/labels/fuhuaqi/del',checkGuanWeiHuiToken, asyncHandler(delFuHuaQiLab));
    /**企业标签 */
    httpServer.post('/admin/labels/enterprise/list',checkGuanWeiHuiToken, asyncHandler(enterpriseLabList));
    httpServer.post('/admin/labels/enterprise/add',checkGuanWeiHuiToken, asyncHandler(addEnterpriseLab));
    httpServer.post('/admin/labels/enterprise/log',checkGuanWeiHuiToken, asyncHandler(enterpriseLabLog));
    httpServer.post('/admin/labels/enterprise/del',checkGuanWeiHuiToken, asyncHandler(delEnterpriseLab));
}


async function labList(req, res) {
    let reqConf = {
        pageNumber:'Number'
    };
    const NotMustHaveKeys = [];
    let {pageNumber} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await labelBiz.labelList(pageNumber);

    res.success(result);
}


async function createLab(req, res) {
    let reqConf = {
        name: 'String',//机构名称
        goal: 'Number' //类型
    };
    const NotMustHaveKeys = [];
    let {goal, name} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await labelBiz.addLabel(name, goal);

    res.success(result);
}


async function updateLab(req, res) {
    let reqConf = {
        name: 'String',//机构名称
        id: 'String' //id
    };
    const NotMustHaveKeys = [];
    let {id, name} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await labelBiz.updateLabelName(id, name);

    res.success(result);
}


async function deleteLab(req, res) {
    let reqConf = {
        id: 'String'//标识
    };
    const NotMustHaveKeys = [];
    let {id} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await labelBiz.deleteLabel(id);

    res.success(result);
}


async function fuHuaQiLabList(req, res) {
    let reqConf = {
        name: 'String',//标识
        labelIdList:'[String]',
        pageNumber:'Number'
    };
    const NotMustHaveKeys = ["name", "pageNumber", "labelIdList"];
    let {name, pageNumber, labelIdList} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await fuHuaQiLabelBiz.fuHuaQiLabelList(name,  pageNumber, labelIdList);

    res.success(result);
    
}

async function addFuHuaQiLab(req, res) {
    let reqConf = {
        uscc: 'String',//企业统一信用代码
        labelIdList:'[String]',//标签列表
    };
    const NotMustHaveKeys = [];
    let {uscc, labelIdList} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await fuHuaQiLabelBiz.addFuHuaQiLabel(uscc, labelIdList);

    res.success(result);   
}


async function delFuHuaQiLab(req, res) {
    let reqConf = {
        uscc: 'String',//企业统一信用代码
        labelIdList:'[String]'//标签列表
    };
    const NotMustHaveKeys = [];
    let {uscc, labelIdList} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await fuHuaQiLabelBiz.deleteFuHUaQiLabel(uscc, labelIdList);

    res.success(result);   
}

async function fuHuaQiLabLog(req, res) {
    let reqConf = {
        uscc: 'String',//企业统一信用代码
    };
    const NotMustHaveKeys = [];
    let {uscc} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await fuHuaQiLabelBiz.labelLogList(uscc);

    res.success(result);   
}


async function enterpriseLabList(req, res) {
    let reqConf = {
        name: 'String',//标识
        labelIdList:'[String]',
        pageNumber:'Number'
    };
    const NotMustHaveKeys = ["name", "pageNumber", "labelIdList"];
    let {name, pageNumber, labelIdList} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseLabelBiz.enterpriseLabelList(name,  pageNumber, labelIdList);

    res.success(result);
    
}

async function addEnterpriseLab(req, res) {
    let reqConf = {
        uscc: 'String',//标识
        labelIdList:'[String]'
    };
    const NotMustHaveKeys = [];
    let {uscc, labelIdList} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseLabelBiz.addEnterpriseLabel(uscc, labelIdList);

    res.success(result);   
}


async function delEnterpriseLab(req, res) {
    let reqConf = { 
        uscc: 'String',//标识
        labelIdList:'[String]'
    };
    const NotMustHaveKeys = [];
    let {uscc, labelIdList} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseLabelBiz.deleteEnterpriseLabel(uscc, labelIdList);

    res.success(result);   
}

async function enterpriseLabLog(req, res) {
    let reqConf = {
        uscc: 'String',//标识
    };
    const NotMustHaveKeys = [];
    let {uscc} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseLabelBiz.enterpriseLabelLogList(uscc);

    res.success(result);   
}


async function labelSelect(req, res) {
    let reqConf = {
        goal:'Number',//1是孵化器 2是企业
    };
    const NotMustHaveKeys = [];
    let {goal} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseLabelBiz.getLabelListByGoal(goal);

    res.success(result);   
}