/**
 * 管理后台端 资讯相关
 */

import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as informationBiz from '../../biz/admin/information';


export function setRouter(httpServer) {
    httpServer.post('/admin/infomation/add',checkGuanWeiHuiToken, asyncHandler(addInformation));
    httpServer.post('/admin/infomation/update',checkGuanWeiHuiToken, asyncHandler(updateInformation));
    httpServer.post('/admin/infomation/delete',checkGuanWeiHuiToken, asyncHandler(deleteInformation));
    httpServer.post('/admin/infomation/info',checkGuanWeiHuiToken, asyncHandler(infoInformation));
    httpServer.post('/admin/infomation/list',checkGuanWeiHuiToken,asyncHandler(listInformation));
    httpServer.post('/admin/infomation/open',checkGuanWeiHuiToken, asyncHandler(openInformation));
    httpServer.post('/admin/infomation/close',checkGuanWeiHuiToken, asyncHandler(closeInformation));
    httpServer.post('/admin/infomation/match',checkGuanWeiHuiToken, asyncHandler(closeInformation));
}


/**
 * 创建资讯
 * @param req 
 * @param res 
 */
async function addInformation(req, res) {
    let reqConf = {
        desc:"String", title:"String" ,source:"String", coverImg:"String"
    };
    const NotMustHaveKeys = ["coverImg"];
    let {desc, title, source, coverImg} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await informationBiz.addOnceInformation(desc, title, source, coverImg);
    res.success(data);
}


/**
 * 修改资讯
 * @param req 
 * @param res 
 */
async function updateInformation(req, res) {
    let reqConf = {
        id:"String", desc:"String", title:"String" ,source:"String", coverImg:"String"
    };
    const NotMustHaveKeys = ["coverImg"];
    let {id, desc, title, source, coverImg} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await informationBiz.updateOnceInformation(id, desc, title, source, coverImg);
    res.success(data);
}


/**
 * 删除资讯
 * @param req 
 * @param res 
 */
async function deleteInformation(req, res) {
    let reqConf = { id:"String" };
    let {id} = eccReqParamater(reqConf, req.body, []);
    let data = await informationBiz.deleteOnceInformationDate(id);
    res.success(data);
}


/**
 * 回显
 * @param req 
 * @param res 
 */
async function infoInformation(req, res) {
    let reqConf = { id:"String" };
    let {id} = eccReqParamater(reqConf, req.body, []);
    let data = await informationBiz.selectOnceInformationDate(id);
    res.success(data);
}


/**
 * 资讯列表
 * @param req 
 * @param res 
 */
async function listInformation(req, res) {
    let reqConf = {
        page:"Number", selectTitle:"String", createTime:"Number", state:"Number"
    };
    const NotMustHaveKeys = ["selectTitle", "createTime", "state"];
    let { selectTitle, createTime, state, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await informationBiz.selectInformation(selectTitle, createTime, state, page);
    res.success(data);
}


/**
 * 打开资讯
 * @param req 
 * @param res 
 */
async function openInformation(req, res) {
    let reqConf = {
        id:"String", isPermanent:"Boolean", closeTimeMs:"Number" 
    };
    const NotMustHaveKeys = ["closeTimeMs"];
    let {id, isPermanent, closeTimeMs} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await informationBiz.openInformation(id, isPermanent, closeTimeMs);
    res.success(data);
}


/**
 * 关闭资讯
 * @param req 
 * @param res 
 */
async function closeInformation(req, res) {
    let reqConf = { id:"String" };
    let {id} = eccReqParamater(reqConf, req.body, []);
    let data = await informationBiz.closeInformation(id);
    res.success(data);
}