/**
 * 管理后台端 孵化器相关
 */

import * as asyncHandler from 'express-async-handler';
import * as monthAdminBiz from '../../biz/admin/fuHuaQi/month';
import * as fuHuaQiAdminBiz from '../../biz/admin/fuHuaQi/fuHuaQi';
import * as taskBiz from '../../biz/mobileFuHuaQi/fuHuaQi/task/monthTask';
import * as provideBiz from '../../biz/admin/provide';
import * as taskTool from '../../tools/taskTool';
import { checkGuanWeiHuiToken, checkInterior } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';


export function setRouter(httpServer) {
    httpServer.post('/admin/fuhuaqi/baselist',checkGuanWeiHuiToken, asyncHandler(fuHuaQiBaseList));
    httpServer.post('/admin/fuhuaqi/monthoccupancyrate',checkGuanWeiHuiToken, asyncHandler(getMonthList));//月度报表
    httpServer.post('/admin/fuhuaqi/userlist',checkGuanWeiHuiToken, asyncHandler(getFuHuaQiUserList));
    httpServer.post('/admin/fuhuaqi/updatestate',checkGuanWeiHuiToken, asyncHandler(updateState));
    httpServer.post('/admin/fuhuaqi/adduser',checkGuanWeiHuiToken,asyncHandler(addUser));
    httpServer.post('/admin/data/output/fuhuaqi',checkGuanWeiHuiToken, asyncHandler(outPutFuHuaQiData));
    httpServer.post('/admin/data/output/month',checkGuanWeiHuiToken, asyncHandler(outPutMonthData));
    /**2.0新加 */
    httpServer.post('/admin/fuhuaqi/updateuserinfo',checkGuanWeiHuiToken, asyncHandler(updateUserInfo));
    /**3.1新加 */
    httpServer.post('/admin/fuhuaqi/instituQualify/',checkGuanWeiHuiToken, asyncHandler(updateUserInfo));

}


/**
 * 孵化器基本信息列表
 * @param req 
 * @param res 
 */
async function fuHuaQiBaseList(req, res) {
    let reqConf = {
        lv: 'Number',
        name:'String',
        institutionalNature: 'Number',//机构性质
        operationModel:"Number",//运营模式
        foundingTeam:"Number",//创业团队
        industry: 'Number', 
        page: 'Number' 
    };
    const NotMustHaveKeys = ["lv", "institutionalNature", "operationModel", "foundingTeam" , "industry", "name"];
    let {lv, institutionalNature, industry, operationModel, foundingTeam, name, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await fuHuaQiAdminBiz.fuHuaQiBaseList(lv, institutionalNature, industry, operationModel, foundingTeam, name, page);

    res.success(result);
}


/**
 * 后台管理  获取月度出租率信息列表
 * @param req 
 * @param res 
 */
async function getMonthList(req, res) {
    let  reqConf = {state: 'Number', year: 'Number', month: 'Number', page: 'Number'};
    const NotMustHaveKeys = ["state", "year", "month"];
    let { state, year, month, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await monthAdminBiz.monthTableList(state, year, month, page);
    res.success(result);
}


/**
 * 后台管理 获取孵化器账号信息列表 
 * @param req 
 * @param res 
 */
 async function getFuHuaQiUserList(req, res) {
    let reqConf = {operationName: 'String', page: 'Number' };
    const NotMustHaveKeys = ["operationName" ];
    let { operationName, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await fuHuaQiAdminBiz.fuHuaQiUserList(operationName, page);
    res.success(result);
}


/**
 * 后台管理 修改孵化器账号状态 
 * @param req 
 * @param res 
 */
 async function updateState(req, res) {
    let reqConf = {userState: 'Boolean', uscc: 'String' };
    let { userState, uscc } = eccReqParamater(reqConf, req.body);

    let result = await fuHuaQiAdminBiz.updateState(uscc, userState);
    res.success(result);
}


/**
 * 后台管理 新增孵化器账号
 * @param req 
 * @param res 
 */
async function addUser(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);

    let result = await fuHuaQiAdminBiz.addUser(form);
    res.success(result);
}



async function outPutFuHuaQiData(req, res) {
    let reqConf = { lv: 'Number',  institutionalNature: 'Number',  industry: 'Number', type:'Number', operationModel:"Number", foundingTeam:"Number", name:"String" };
    const NotMustHaveKeys = ["lv", "institutionalNature", "industry", "operationModel", "foundingTeam", "name"];
    let { lv, institutionalNature, industry, type, operationModel, foundingTeam, name } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let dataList = await fuHuaQiAdminBiz.outPutFuHuaQiBaseData(lv, institutionalNature, industry, operationModel, foundingTeam, name, type);
    
    let fileName = `孵化器列表${taskTool.getTimeKey()}.xlsx`;

    res.success({name:fileName, data:dataList});
    
}



async function outPutMonthData(req, res) {
    let  reqConf = {state: 'Number', year: 'Number', month: 'Number', type:'Number'};
    const NotMustHaveKeys = ["state", "year", "month"];
    let { state, year, month, type } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let dataList = await monthAdminBiz.outPutMonthTableList(state, year, month, type);

    let name = `月度任务${taskTool.getTimeKey()}.xlsx`;

    res.success({name, data:dataList});
}


async function updateUserInfo(req, res) {
    let  reqConf = {uscc: 'String', phone: 'String', name: 'String' };
    const NotMustHaveKeys = [];
    let { uscc, phone, name } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await fuHuaQiAdminBiz.updateFuHuaQiData(uscc, phone, name);

    res.success(result);
}