/**
 * 管理后台端 企业相关 
 * 包括 在孵企业页面
 * 包括 企业融资页面 
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseAdminBiz from '../../biz/admin/enterprise/enterprise';
import * as financingAdminBiz from '../../biz/admin/enterprise/financing';
import  * as taskTool from '../../tools/taskTool';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as trackBiz from '../../biz/admin/fuHuaQi/track';

export function setRouter(httpServer) {
    httpServer.post('/admin/enterprise/list',checkGuanWeiHuiToken, asyncHandler(getEnterpriseList));
    httpServer.post('/admin/enterprise/teaminfo/list',checkGuanWeiHuiToken, asyncHandler(enterpriseTeamInfoList));
    httpServer.post('/admin/data/output/enterprise',checkGuanWeiHuiToken, asyncHandler(outPutEnterpriseData));
    httpServer.post('/admin/enterprise/financinglist',checkGuanWeiHuiToken, asyncHandler(getFinancingList));
    httpServer.post('/admin/data/output/financing',checkGuanWeiHuiToken, asyncHandler(outPutFinancingData));
    /**所属孵化器下拉框 */
    httpServer.post('/admin/enterprise/affiliationfuhuaqi',checkGuanWeiHuiToken,asyncHandler(affiliationFuHuaQi));
    /**迁出企业2.0新加 */
    httpServer.post('/admin/enterprise/moveoutlist',checkGuanWeiHuiToken, asyncHandler(moveOutList));
    httpServer.post('/admin/data/output/moveoutlist',checkGuanWeiHuiToken, asyncHandler(outPutMoveOutList));
    /**经营数据3.0新加 */
    httpServer.post('/admin/enterprise/businessdatalist',checkGuanWeiHuiToken, asyncHandler(businessDataList));
    httpServer.post('/admin/data/output/businessdatalist',checkGuanWeiHuiToken, asyncHandler(outPutBusinessData));
    /**企业填报的融资数据3.0新加 */
    httpServer.post('/admin/enterprise/financinginfolist',checkGuanWeiHuiToken, asyncHandler(financingInfoList));
    httpServer.post('/admin/data/output/financinginfolist',checkGuanWeiHuiToken, asyncHandler(outPutFinancingInfoList));
    /**企业创始团队列表 */
    httpServer.post('/admin/enterprise/initialteam',checkGuanWeiHuiToken, asyncHandler(initialTeamList));
    httpServer.post('/admin/data/output/initialteam',checkGuanWeiHuiToken, asyncHandler(outPutEnterpriseInitialTeamList));   
    /**企业名称编辑 */
    httpServer.post('/admin/enterprise/info',checkGuanWeiHuiToken, asyncHandler(enterpriseInfo));
    httpServer.post('/admin/enterprise/info/update',checkGuanWeiHuiToken, asyncHandler(updateEnterpriseInfo));

    /**加速企业 */

    httpServer.post('/admin/enterprise/jsqy/list',checkGuanWeiHuiToken, asyncHandler(jsqy_list));
    httpServer.post('/admin/enterprise/jsqy/info',checkGuanWeiHuiToken, asyncHandler(jsqy_info));
    httpServer.post('/admin/enterprise/jsqy/update',checkGuanWeiHuiToken, asyncHandler(jsqy_update));

    httpServer.post('/admin/enterprise/zlqy/list',checkGuanWeiHuiToken, asyncHandler(zlqy_list));
    httpServer.post('/admin/enterprise/zlqy/info',checkGuanWeiHuiToken, asyncHandler(zlqy_info));
    httpServer.post('/admin/enterprise/zlqy/update',checkGuanWeiHuiToken, asyncHandler(zlqy_update));
    httpServer.post('/admin/enterprise/zlqy/rentPayment/list',checkGuanWeiHuiToken, asyncHandler(zlqy_rentPayment_list));
    httpServer.post('/admin/enterprise/zlqy/rentPayment/update',checkGuanWeiHuiToken, asyncHandler(zlqy_rentPayment_update));

    httpServer.post('/admin/enterprise/demand/list',checkGuanWeiHuiToken, asyncHandler(demand_list));
    httpServer.post('/admin/enterprise/demand/label',checkGuanWeiHuiToken, asyncHandler(demand_label));
    httpServer.post('/admin/enterprise/demand/info',checkGuanWeiHuiToken, asyncHandler(demand_info));
    httpServer.post('/admin/enterprise/demand/create',checkGuanWeiHuiToken, asyncHandler(demand_create));
    httpServer.post('/admin/enterprise/demand/update',checkGuanWeiHuiToken, asyncHandler(demand_update));
    httpServer.post('/admin/enterprise/demand/del',checkGuanWeiHuiToken, asyncHandler(demand_del));

    httpServer.post('/admin/enterprise/keynote/list',checkGuanWeiHuiToken, asyncHandler(keynote_list));//重点企业
    httpServer.post('/admin/enterprise/keynote/activity',checkGuanWeiHuiToken, asyncHandler(keynote_activity_list));
    httpServer.post('/admin/enterprise/keynote/add',checkGuanWeiHuiToken, asyncHandler(add_keynote));
    httpServer.post('/admin/enterprise/keynote/del',checkGuanWeiHuiToken, asyncHandler(del_keynote));

    httpServer.post('/admin/enterprise/namelist', checkGuanWeiHuiToken, asyncHandler(getNameList));

    httpServer.post('/admin/enterprise/track/list',checkGuanWeiHuiToken, asyncHandler(track_list));//
    httpServer.post('/admin/enterprise/track/info',checkGuanWeiHuiToken, asyncHandler(track_info));//
    httpServer.post('/admin/enterprise/track/changestate',checkGuanWeiHuiToken, asyncHandler(track_changestate));//
    httpServer.post('/admin/enterprise/track/del',checkGuanWeiHuiToken, asyncHandler(track_del));//

}

async function track_del(req, res) {
    let reqConf = {id:'String'};
    const NotMustHaveKeys = [ ];
    let { id } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await trackBiz.deleteTrack(id);
    res.success(result);
}

async function track_changestate(req, res) {
    let reqConf = {id:'String', state:'Number'};
    const NotMustHaveKeys = [ ];
    let { id, state } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await trackBiz.changeTrackState(id, state);

    res.success(result);
}



async function track_info(req, res) {
    let reqConf = {uscc:'String'};
    const NotMustHaveKeys = [ ];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await trackBiz.trackInfo(uscc);
    res.success(result);
}


async function track_list(req, res) {
    let reqConf = {name:'String', type:'Number', state:'Number', page:'Number'};
    const NotMustHaveKeys = [ "name", "type", "state"];
    let { name, type, state, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await trackBiz.trackList(name, type, state, page );
    res.success(result);
}


async function del_keynote(req, res) {
    let reqConf = {uscc:'String'};
    const NotMustHaveKeys = [];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseAdminBiz.delKeynote(uscc);
    res.success(result);
}

async function add_keynote(req, res) {
    let reqConf = {uscc:'String', label:'[Number]'};
    const NotMustHaveKeys = [];
    let { uscc, label } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseAdminBiz.addKeynote(uscc, label);

    res.success(result);
}

async function keynote_list(req, res) {
    let reqConf = {name:'String', type:'Number', page:'Number'};
    const NotMustHaveKeys = [ "name", "type"];
    let { name, type, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseAdminBiz.keynoteList(name, type, page);
    res.success(result);
}

async function keynote_activity_list(req, res) {
    let reqConf = {uscc:'String'};
    const NotMustHaveKeys = [];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseAdminBiz.keynoteActivityList(uscc);
    
    res.success(result);
}


async function getNameList(req, res) {
    let reqConf = {name:'String'};
    const NotMustHaveKeys = [ "name"];
    let { name } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseAdminBiz.enterpriseNameList(name);
    res.success(result);
}

async function demand_list(req, res) {
    let reqConf = {name:'String', demand: 'Number', page:"Number"};
    const NotMustHaveKeys = [ "name", "demand"];
    let { name, demand, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.demandList( name, demand, page);
    res.success(result);
}

async function demand_label(req, res) {
    let reqConf = {uscc:'String', demand: 'Number' };
    const NotMustHaveKeys = [];
    let { uscc, demand } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.demandLabel( uscc, demand);
    res.success(result);
}

async function demand_info(req, res) {
    let reqConf = {uscc:'String'};
    const NotMustHaveKeys = [];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.demandInfo(uscc);
    res.success(result);
}

async function demand_create(req, res) {
    let reqConf = {uscc:'String', demand: '[Number]', demandDesc:'String' };
    const NotMustHaveKeys = [];
    let { uscc, demand, demandDesc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.demandCreate(uscc, demand, demandDesc);
    res.success(result);
}
async function demand_update(req, res) {
    let reqConf = {id:'String', demand: '[Number]'};
    const NotMustHaveKeys = [];
    let { id, demand } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.demandUpdate(id, demand);
    res.success(result);
}


async function demand_del(req, res) {
    let reqConf = {id:'String'};
    const NotMustHaveKeys = [];
    let { id } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.removeDemand(id);
    res.success(result);
}


async function zlqy_list(req, res) {
    let reqConf = {name:'String', contractState: 'Number', page:"Number", state:"Number"};
    const NotMustHaveKeys = [ "state", "contractState", "name"];
    let { name, contractState, state, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.zlqyList( name, contractState, state, page);
    res.success(result);
}

async function zlqy_info(req, res) {
    let reqConf = {uscc:"String"};
    const NotMustHaveKeys = [];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let restult = await enterpriseAdminBiz.zlqyInfo(uscc);
    res.success(restult);
}

async function zlqy_update(req, res) {
    let reqConf = {uscc:"String", param:"Object"};
    const NotMustHaveKeys = [];
    let { uscc, param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let restult = await enterpriseAdminBiz.zlqyUpdate(uscc, param);

    res.success(restult);
}

async function zlqy_rentPayment_list(req, res) {
    let reqConf = {uscc:'String'};
    const NotMustHaveKeys = [ ];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.zlqyrentPaymentList(uscc);
    res.success(result);
}

async function zlqy_rentPayment_update(req, res) {
    let reqConf = {uscc:"String", rentPayment:"[Object]"};
    const NotMustHaveKeys = [];
    let { uscc, rentPayment } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let restult = await enterpriseAdminBiz.zlqyrentPaymentUpdate(uscc, rentPayment);

    res.success(restult);
}


async function jsqy_list(req, res) {
    let reqConf = {name:'String', industry: '[Number]', jiaSuZiZhi:'[Number]', page:"Number", isNaturalPersonHolding:"Number"};
    const NotMustHaveKeys = ["createType", "fuHuaQiUscc", "industry",  "state", "createTime", "name"];
    let { name, industry, jiaSuZiZhi, page, isNaturalPersonHolding } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.jiasuEnterprise(name, industry, jiaSuZiZhi, isNaturalPersonHolding, page);
    res.success(result);
}

/**
 * 企业信息回显
 */
async function jsqy_info(req, res) {
    let reqConf = {uscc:"String"};
    const NotMustHaveKeys = [];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let restult = await enterpriseAdminBiz.jsqInfo(uscc);
    res.success(restult);
}

async function jsqy_update(req, res) {
    let reqConf = {uscc:"String", param:"Object"};
    const NotMustHaveKeys = [];
    let { uscc, param } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let restult = await enterpriseAdminBiz.jsqyUpdate(uscc, param);

    res.success(restult);
}



/**
 * 后台管理 获取在孵企业信息列表 
 * @param req 
 * @param res 
 */
async function getEnterpriseList(req, res) {
    let reqConf = {name:'String', createType: 'Number', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', state:'Number', createTime:'Number', page: 'Number' };
    const NotMustHaveKeys = ["createType", "fuHuaQiUscc", "industry", "isNaturalPersonHolding", "state", "createTime", "name"];
    let { createType, fuHuaQiUscc, industry, isNaturalPersonHolding, state, createTime, name, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
    }
    let result = await enterpriseAdminBiz.enterpriseList(createType, fuHuaQiUscc, industry, isNaturalPersonHolding, state, createTime, name, page);
    res.success(result);
}


/**
 * 管理后台 企业库->在孵企业->点击查看团队信息
 * @param req 
 * @param res 
 */
async function enterpriseTeamInfoList(req, res) {
    let reqConf = {uscc:'String' };
    const NotMustHaveKeys = [];
    
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.getEnterpriseTeamInfoList(uscc);
    res.success(result);
}


/**
 * 后台管理 获取融资企业信息列表 
 * @param req 
 * @param res
 */
async function getFinancingList(req, res) {
    let reqConf = {monthData: 'String', fuHuaQiName: 'String', fuHuaQiInvestment: 'Number', industry: '[Number]', page: 'Number' };
    const NotMustHaveKeys = ["monthData", "fuHuaQiName", "fuHuaQiInvestment", "industry" ];
    let {monthData, fuHuaQiName, industry, fuHuaQiInvestment, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    if (req.headers.isFuHuaQi) {
        fuHuaQiName = req.headers.userid;
    }

    let result = await financingAdminBiz.financingList(monthData, fuHuaQiName, industry, fuHuaQiInvestment, page);
    res.success(result);
}


/**
 * 所属孵化器
 * 下拉框
 * @param req 
 * @param res 
 */
async function affiliationFuHuaQi(req, res) {
    let  result = await enterpriseAdminBiz.getAffiliationFuHuaQi();
    res.success(result);
}


/**
 * 导出在孵企业数据
 * @param req 
 * @param res 
 */
async function outPutEnterpriseData(req, res) {
    let reqConf = {name:'String', createType: 'Number', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number',  state:'Number', createTime:'Number', type:'Number' };
    const NotMustHaveKeys = ["createType", "fuHuaQiUscc", "industry", "isNaturalPersonHolding", "state", "createTime", "name" ];
    let { createType, fuHuaQiUscc, industry, isNaturalPersonHolding, type, state, createTime, name } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let isFuHuaQi = false;
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
        isFuHuaQi = true;
    }

    let dataList = await enterpriseAdminBiz.outPutEnterpriseData(createType, fuHuaQiUscc, industry, isNaturalPersonHolding, state, createTime, name, type, isFuHuaQi);

    let fileName = `在孵企业${taskTool.getTimeKey()}.xlsx`;

    res.success({name:fileName, data:dataList});
}


/**
 * 导出企业融资数据
 * @param req 
 * @param res 
 */
async function outPutFinancingData(req, res) {
    let reqConf = {monthData: 'String', fuHuaQiName: 'String', fuHuaQiInvestment: 'Number', industry: '[Number]', type:'Number' };
    const NotMustHaveKeys = ["monthData", "fuHuaQiName", "fuHuaQiInvestment", "industry" ];
    let {monthData, fuHuaQiName, industry, fuHuaQiInvestment, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let isFuHuaQi = false;
    if (req.headers.isFuHuaQi) {
        fuHuaQiName = req.headers.fuHuaQiName;
        isFuHuaQi = true;
    }

    let dataList = await financingAdminBiz.outPutFinancingList(monthData, fuHuaQiName, industry, fuHuaQiInvestment, type, isFuHuaQi);

    let name = `融资企业${taskTool.getTimeKey()}.xlsx`;

    res.success({name, data:dataList});
}


/**
 * 迁出企业列表
 * 2.0
 * @param req 
 * @param res 
 */
async function moveOutList(req, res) {
    let reqConf = {name:'String', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', page: 'Number' };
    const NotMustHaveKeys = ["name", "fuHuaQiUscc", "industry", "isNaturalPersonHolding" ];
    let { name, fuHuaQiUscc, industry, isNaturalPersonHolding, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
    }

    let restult = await enterpriseAdminBiz.enterpriseMoveOutList(name, fuHuaQiUscc, industry, isNaturalPersonHolding, page);

    res.success(restult);
}


/**
 * 导出迁出企业列表
 * 2.0
 * @param req 
 * @param res 
 */
async function outPutMoveOutList(req, res) {
    let reqConf = {name:'String', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', type: 'Number' };
    const NotMustHaveKeys = ["name", "fuHuaQiUscc", "industry", "isNaturalPersonHolding" ];
    let { name, fuHuaQiUscc, industry, isNaturalPersonHolding, type } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let isFuHuaQi = false;
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
        isFuHuaQi = true;
    }
    let {dataList, fileName} = await enterpriseAdminBiz.outPutEnterpriseMoveOutList(name, fuHuaQiUscc, industry, isNaturalPersonHolding, type, isFuHuaQi);

    res.success({data:dataList, name:`迁出企业${fileName}.xlsx`});

}


/**
 * 企业经营数据列表
 * @param req 
 * @param res 
 */
async function businessDataList(req, res) {
    let reqConf = {name:'String', year: 'Number', quarter: 'Number', page: 'Number'};
    const NotMustHaveKeys = ["name", "year", "quarter" ];
    let { name, year, quarter, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let fuHuaQiUscc = undefined;
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
    } 

    let restult = await enterpriseAdminBiz.getBusinessDataList(name, year, quarter, page, fuHuaQiUscc);

    res.success(restult);
}


/**
 * 导出企业经营数据列表
 * @param req 
 * @param res 
 */
async function outPutBusinessData(req, res) {
    let reqConf = {name:'String', year: 'Number', quarter: 'Number', type: 'Number'};
    const NotMustHaveKeys = ["name", "year", "quarter" ];
    let { name, year, quarter, type } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let fuHuaQiUscc = undefined;
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
    } 

    let {dataList, fileName} = await enterpriseAdminBiz.outPutBusinessDataList(name, year, quarter, type, fuHuaQiUscc);

    res.success({data:dataList, name:`${fileName}企业经营.xlsx`});
}


/**
 * 企业填报的融资数据列表
 * @param req 
 * @param res 
 */
async function financingInfoList(req, res) {
    let reqConf = {name:'String', financingRounds: 'Number', fuHuaQiInvestment: 'Number', page: 'Number'};
    const NotMustHaveKeys = ["name", "financingRounds", "fuHuaQiInvestment" ];
    let { name, financingRounds, fuHuaQiInvestment, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let fuHuaQiUscc = undefined;
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
    } 

    let restult = await financingAdminBiz.getEnterpriseFinancing(name, financingRounds, fuHuaQiInvestment, page, fuHuaQiUscc);

    res.success(restult);
}


/**
 * 导出企业填报的融资数据列表
 * @param req 
 * @param res 
 */
async function outPutFinancingInfoList(req, res) {
    let reqConf = {name:'String', financingRounds: 'Number', fuHuaQiInvestment: 'Number', type: 'Number'};
    const NotMustHaveKeys = ["name", "financingRounds", "fuHuaQiInvestment" ];
    let { name, financingRounds, fuHuaQiInvestment, type } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let fuHuaQiUscc = undefined;
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
    } 

    let {dataList, fileName} = await financingAdminBiz.outPutEnterpriseFinancing(name, financingRounds, fuHuaQiInvestment, type, fuHuaQiUscc);

    res.success({data:dataList, name:`${fileName}企业填报融资数据.xlsx`});
}


/**
 * 企业创始团队列表
 * @param req 
 * @param res 
 */
async function initialTeamList(req, res) {
    let reqConf = {name:"String", member:"String", type:"Number", page: 'Number'};
    const NotMustHaveKeys = ["name", "member", "type" ];
    let { name, member, type, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
   let fuHuaQiUscc = undefined;
   if (req.headers.isFuHuaQi) {
       fuHuaQiUscc = req.headers.userid;
   } 

    let restult = await enterpriseAdminBiz.getInitialTeamList(name, member, type, page, fuHuaQiUscc);

    res.success(restult);
}


/**
 * 导出企业创始团队列表
 * @param req 
 * @param res 
 */
async function outPutEnterpriseInitialTeamList(req, res) {
    let reqConf = {name:"String", member:"String", type:"Number", memberType: 'Number'};
    const NotMustHaveKeys = ["name", "member", "memberType" ];
    let { name, member, type, memberType } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let fuHuaQiUscc = undefined;
    if (req.headers.isFuHuaQi) {
        fuHuaQiUscc = req.headers.userid;
    } 

    let {dataList, fileName} = await enterpriseAdminBiz.outPutInitialTeamList(name, member, memberType, type, fuHuaQiUscc);

    res.success({data:dataList, name:`${fileName}企业创始团队数据.xlsx`});
}


/**
 * 企业信息回显
 */
async function enterpriseInfo(req, res) {
    let reqConf = {uscc:"String"};
    const NotMustHaveKeys = [];
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let restult = await enterpriseAdminBiz.enterpriseInfomation(uscc);

    res.success(restult);
}


/**
 * 企业信息修改
 */
async function updateEnterpriseInfo(req, res) {
    let reqConf = {uscc:"String", name:"String"};
    const NotMustHaveKeys = [];
    let { uscc, name } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let restult = await enterpriseAdminBiz.updateEnterpriseInfomation(uscc, name);

    res.success(restult);
}
