
/**
 * 管理后台端 企业相关 
 * 包括 在孵企业页面
 * 包括 企业融资页面 
 */

import * as asyncHandler from 'express-async-handler';
import { checkDataAsyncInterior } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import { syncMonthTask, asyncCheckTask } from '../../biz/dataSynchronous';
 
export function setRouter(httpServer) {
    httpServer.post('/admin/dataasync/task',checkDataAsyncInterior, asyncHandler(taskSync)); 
    httpServer.post('/admin/dataasync/task/submit',checkDataAsyncInterior, asyncHandler(submitTask)); 
}
 
async function taskSync(req, res) {
    let reqConf = {enterpriseList:'[Object]', rate:'Number'};
    const NotMustHaveKeys = [ ];
    let { rate, enterpriseList } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await syncMonthTask(enterpriseList, rate);
    res.success(result);
}

async function submitTask(req, res) {
    
    let result = await asyncCheckTask();
    res.success(result);
}