/**
 * 管理后台端 数据校验
 */

import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import { checkEnterpriseDataList, dwEnterpriseDataList, monthData, upCheckEnterpriseData } from '../../biz/admin/checkData/checkMonthData';


export function setRouter(httpServer) {
    httpServer.post('/admin/checkdata/list',checkGuanWeiHuiToken, asyncHandler(checkDataList));
    httpServer.post('/admin/checkdata/list/dw',checkGuanWeiHuiToken, asyncHandler(dwCheckDataList));
    httpServer.post('/admin/checkdata/list/check',checkGuanWeiHuiToken, asyncHandler(checkData));
    httpServer.post('/admin/checkdata/monthdata/dw',checkGuanWeiHuiToken, asyncHandler(dwMonthDataList));
}


/**
 * 校验数据列表
 * @param req 
 * @param res 
 */
async function checkDataList(req, res) {
    let reqConf = {page: 'Number' };
    const NotMustHaveKeys = [];
    let {  page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await checkEnterpriseDataList(page);
    res.success(result);
}

/**
 * 下载校验数据
 * @param req 
 * @param res 
 */
async function dwCheckDataList(req, res) {

    let result = await dwEnterpriseDataList();
    res.success(result);
}


async function checkData(req, res) {
    let reqConf = {dataList: '[Object]' };
    const NotMustHaveKeys = [];
    let {  dataList } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await upCheckEnterpriseData(dataList);
    res.success(result);
}

/**
 * 下载校验数据
 * @param req 
 * @param res 
 */
async function dwMonthDataList(req, res) {

    let result = await monthData();
    res.success(result);
}

