/**
 * 活动
 */

import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as activityBiz from '../../biz/activity';

export function setRouter(httpServer) {
    httpServer.post('/admin/activity/add',checkGuanWeiHuiToken, asyncHandler(addInformation));
    httpServer.post('/admin/activity/update',checkGuanWeiHuiToken, asyncHandler(updateInformation));
    httpServer.post('/admin/activity/delete',checkGuanWeiHuiToken, asyncHandler(deleteInformation));
    httpServer.post('/admin/activity/info',checkGuanWeiHuiToken, asyncHandler(infoInformation));
    httpServer.post('/admin/activity/list',checkGuanWeiHuiToken,asyncHandler(listInformation));
    httpServer.post('/admin/activity/open',checkGuanWeiHuiToken, asyncHandler(openInformation));
    httpServer.post('/admin/activity/close',checkGuanWeiHuiToken, asyncHandler(closeInformation));
    httpServer.post('/admin/activity/match',checkGuanWeiHuiToken, asyncHandler(matchInfomation));
}



/**
 * 创建资讯
 * @param req 
 * @param res 
 */
async function addInformation(req, res) {
    let reqConf = {
        desc:"String", title:"String" ,source:"String", coverImg:"String", startTime:"Number", endTime:"Number", target:"[Number]"
    };
    const NotMustHaveKeys = ["coverImg"];
    let {desc, title ,source, coverImg, startTime, endTime, target} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await activityBiz.addOnceInformation(desc, title ,source, coverImg, startTime, endTime, target);
    res.success(data);
}


/**
 * 修改资讯
 * @param req 
 * @param res 
 */
async function updateInformation(req, res) {
    let reqConf = {
        id:"String", desc:"String", title:"String" ,source:"String", coverImg:"String", startTime:"Number", endTime:"Number", target:"[Number]"
    };
    const NotMustHaveKeys = ["coverImg"];
    let {id, desc, title, source, coverImg, startTime, endTime, target} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await activityBiz.updateOnceInformation(id, desc, title, source, coverImg, startTime, endTime, target);
    res.success(data);
}


/**
 * 删除资讯
 * @param req 
 * @param res 
 */
async function deleteInformation(req, res) {
    let reqConf = { id:"String" };
    let {id} = eccReqParamater(reqConf, req.body, []);
    let data = await activityBiz.deleteOnceInformationDate(id);
    res.success(data);
}


/**
 * 回显
 * @param req 
 * @param res 
 */
async function infoInformation(req, res) {
    let reqConf = { id:"String" };
    let {id} = eccReqParamater(reqConf, req.body, []);
    let data = await activityBiz.selectOnceInformationDate(id);
    res.success(data);
}


/**
 * 资讯列表
 * @param req 
 * @param res 
 */
async function listInformation(req, res) {
    let reqConf = {
        page:"Number", selectTitle:"String", createTime:"Number", state:"Number",target:"Number"
    };
    const NotMustHaveKeys = ["selectTitle", "createTime", "state", "target"];
    let { selectTitle, createTime, state, page, target } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await activityBiz.selectInformation(selectTitle, createTime, state, target,page);
    res.success(data);
}


/**
 * 打开资讯
 * @param req 
 * @param res 
 */
async function openInformation(req, res) {
    let reqConf = {
        id:"String", isPermanent:"Boolean", closeTimeMs:"Number" 
    };
    const NotMustHaveKeys = ["closeTimeMs"];
    let {id, isPermanent, closeTimeMs} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let data = await activityBiz.openInformation(id, isPermanent, closeTimeMs);
    res.success(data);
}


/**
 * 关闭资讯
 * @param req 
 * @param res 
 */
async function closeInformation(req, res) {
    let reqConf = { id:"String" };
    let {id} = eccReqParamater(reqConf, req.body, []);
    let data = await activityBiz.closeInformation(id);
    res.success(data);
}

async function matchInfomation(req, res) {
    let reqConf = { id:"String" };
    let {id} = eccReqParamater(reqConf, req.body, []);
    let data = await activityBiz.selectInfoEnterprise(id);
    res.success(data);
}