import { ERRORENUM } from "../config/errorEnum";
import { findEnterpriseByUscc } from "../data/enterprise/enterprise";
import { findFuHuaQiByUSCC } from "../data/fuHuaQi/fuhuaqi";
import { findGuanWeiHuiUserInfoByLoginId } from "../data/guanWeiHui/guanweihui";
import { BizError } from "../util/bizError";


/**
 * 管委会小程序中间件
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkGuanWeiHuiMobileToken(req, res, next) {   
    if (!req.headers) req.headers = {};

    const reqToken = req.headers.token;
    const userId = req.headers.userid || "";

    if (!userId) return next(new BizError(ERRORENUM.身份验证失败, `userId:${userId} token:${reqToken}`));

    let userInfo = await findGuanWeiHuiUserInfoByLoginId(userId);
    if (!userInfo) return next(new BizError(ERRORENUM.非法登录, `userId:${userId} token:${reqToken}`));
    
    /**2023-2-8日需求  登录一次一直有效 */
    // if (userInfo.token != reqToken || (new Date().valueOf() - userInfo.tokenMs) > (3600*100*24*7) ) return next(new BizError(ERRORENUM.身份验证过期, `userId:${userId} token:${reqToken}`));
    if (userInfo.mobileToken != reqToken ) return next(new BizError(ERRORENUM.身份验证过期, `userId:${userId} token:${reqToken}`));

    req.headers.uscc = req.headers.userid;

    next();
}


/**
 * 中间件 校验孵化器token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkFuHuaQiToken(req, res, next) {
    if (!req.headers) req.headers = {};

    const reqToken = req.headers.token;
    const userId = req.headers.userid || "";

    if (!userId) return next(new BizError(ERRORENUM.身份验证失败, `userId:${userId} token:${reqToken}`));

    let userInfo = await findFuHuaQiByUSCC(userId);
    if (!userInfo) return next(new BizError(ERRORENUM.非法登录, `userId:${userId} token:${reqToken}`));
    
    /**2023-2-8日需求  登录一次一直有效 */
    // if (userInfo.token != reqToken || (new Date().valueOf() - userInfo.tokenMs) > (3600*100*24*7) ) return next(new BizError(ERRORENUM.身份验证过期, `userId:${userId} token:${reqToken}`));
    if (userInfo.token != reqToken ) return next(new BizError(ERRORENUM.身份验证过期, `userId:${userId} token:${reqToken}`));

    req.headers.uscc = req.headers.userid;

    next();
}


/**
 * 中间件 校验管委会token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkGuanWeiHuiToken(req, res, next) {
    if (!req.headers) req.headers = {};

    const ReqToken = req.headers.token || "";
    const UserId = req.headers.userid || "";

    if (!UserId) return next(new BizError(ERRORENUM.身份验证失败, `userId:${UserId} token:${ReqToken}`));

    if (ReqToken.length == 32) {
        //管委会
        let userInfo = await findGuanWeiHuiUserInfoByLoginId(UserId);
        if (!userInfo || !userInfo.loginId) return next(new BizError(ERRORENUM.非法登录, `userId:${UserId} token:${ReqToken}`));
        if (userInfo.token != ReqToken ) return next(new BizError(ERRORENUM.身份验证过期, `userId:${UserId} token:${ReqToken}`));

        req.headers.isFuHuaQi = false;

    } else if (ReqToken.length == 34) {
        //孵化器
        let userInfo = await findFuHuaQiByUSCC(UserId);
        if (!userInfo || !userInfo.uscc) return next(new BizError(ERRORENUM.非法登录, `userId:${UserId} token:${ReqToken}`));
        if (userInfo.adminToken != ReqToken) return next(new BizError(ERRORENUM.身份验证过期, `userId:${UserId} token:${ReqToken}`));

        req.headers.userid = req.headers.userid;
        req.headers.isFuHuaQi = true;
        req.headers.operationName = userInfo.operationName;
        req.headers.fuHuaQiName = userInfo.fuHuaQiName;
    } else {
        return next(new BizError(ERRORENUM.身份验证失败, `${UserId}的tokne不合规`));
    }

    next();
}


/**
 * 中间件 校验企业token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkEnterpriseToken(req, res, next) {
    if (!req.headers) req.headers = {};

    const reqToken = req.headers.token;
    const userId = req.headers.userid || "";

    if (!userId) return next(new BizError(ERRORENUM.身份验证失败, `userId:${userId} token:${reqToken}`));

    let userInfo = await findEnterpriseByUscc(userId);
    if (!userInfo) return next(new BizError(ERRORENUM.非法登录, `userId:${userId} token:${reqToken}`));
    
    /**2023-2-8日需求  登录一次一直有效 */
    // if (userInfo.token != reqToken || (new Date().valueOf() - userInfo.tokenMs) > (3600*100*24*7) ) return next(new BizError(ERRORENUM.身份验证过期, `userId:${userId} token:${reqToken}`));
    if (userInfo.token != reqToken ) return next(new BizError(ERRORENUM.身份验证过期, `userId:${userId} token:${reqToken}`));

    req.headers.uscc = req.headers.userid;

    next();
}


/**
 * 中间件 数据维护接口
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkInterior(req, res, next) {
    if (!req.headers) req.headers = {};

    const Sign = req.headers.sign;

    let sysSign = 'sadfjslakdfjlksadjffujisdaiofjsajl09092302'
   
    if (!Sign || Sign != sysSign) return next(new BizError(ERRORENUM.非法登录, `内部接口非法调用 ${Sign}`));

    next();
}


/**
 * 中间件 数据同步接口
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
 export async function checkDataAsyncInterior(req, res, next) {
    if (!req.headers) req.headers = {};

    const Sign = req.headers.sign;

    let sysSign = 'sadfjslakdfjlksadjffujisdaiofjsajl09092302ddd'
   
    if (!Sign || Sign != sysSign) return next(new BizError(ERRORENUM.非法登录, `内部接口非法调用 ${Sign}`));

    next();
}