/**
 * 租赁信息
 */


import {Schema} from 'mongoose';
import { baseDB } from '../db/mongo/dbInit';


const rentPaymentScheme = new Schema({
    payStartTime:Number,//缴纳开始时间
    payLong:Number//缴纳时长
})

const leaseSchema = new Schema({
    uscc:String,
    enterpriseName:String,
    contractStartTime:Number,
    contractEndTime:Number,
    contractLong:Number,
    price:Number,//单价
    area:Number,//租赁面积
    areaUnit:Number,//单位
    rentPayment:{type:[rentPaymentScheme], default:[]},//租金缴纳情况
    address:String,//地址
});


var leaseModel;
export function initModel(){
    leaseModel = baseDB.model('lease', leaseSchema);
    leaseModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await leaseModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

export async function findOnceData(param) {
    return await leaseModel.selectOnceData(param);
}

export async function findData(param) {
    return await leaseModel.find(param);
}
 
export async function createData(addInfo) {
    await leaseModel.create(addInfo);
}
