/**管委会月报 */

import moment = require("moment");
import { FUHUAQILV, FUHUASTATE, INDUSTRY, INSTITUTIONALNATURE } from "../../config/enum";
import { findEnterpriseList } from "../enterprise/enterprise";
import { findFuHuaQiCount, findFuHuaQiList } from "../fuHuaQi/fuhuaqi";
import { findTaskListByParam } from "../fuHuaQi/monthTask/task";
import { findMonthTableList, findMonthTableListCount } from "../fuHuaQi/monthTask/monthTable";
import { changeEnumValue } from "../../util/verificationEnum";


export async function gtest() {
    let fuHuaQiCountParam = {userState:false, uscc:{"$ne":"123456789123456789"}};
    let fuHuaQiCount = await findFuHuaQiCount(fuHuaQiCountParam);//孵化器个数

    let fuHuaQiList = await findFuHuaQiList(fuHuaQiCountParam);

    let acreageTotalCount = 0;
    let incubatedAcreageCount = 0;
    let lvMap = {
        1:{name:FUHUAQILV[FUHUAQILV.国家级众创空间], count:0},
        2:{name:FUHUAQILV[FUHUAQILV.市级众创空间], count:0},
        3:{name:FUHUAQILV[FUHUAQILV.国家级孵化器], count:0},
        4:{name:FUHUAQILV[FUHUAQILV.市级孵化器], count:0},
        5:{name:FUHUAQILV[FUHUAQILV.区级], count:0}
    };
    let institutionalNatureMap = {
        1:{name:INSTITUTIONALNATURE[INSTITUTIONALNATURE.国资为主], count:0},
        2:{name:INSTITUTIONALNATURE[INSTITUTIONALNATURE.民资为主], count:0},
        3:{name:INSTITUTIONALNATURE[INSTITUTIONALNATURE.外资为主], count:0}
    };
    let industryMap = {};
    for (let key in INDUSTRY) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            industryMap[INDUSTRY[key]]= {name:keyStr, count:0}
        }
    }
    let fuHuaQiUsccNameMap = {};
    fuHuaQiList.forEach(info => {
        let {acreageTotal, incubatedAcreage, acreagePersonalUse, institutionalNature, industry, lv} = info;
        if (acreageTotal) acreageTotalCount += acreageTotal;
        if (incubatedAcreage) incubatedAcreageCount += incubatedAcreage;

        if(lv) lvMap[lv].count += 1;
        institutionalNatureMap[institutionalNature].count += 1;
        if (industry[0]) {
            industryMap[industry[0]].count += 1;
        }
        fuHuaQiUsccNameMap[info.uscc] = {opName:info.operationName, name:info.name, acreageTotal}
        

    });
    console.log("孵化器总面积", acreageTotalCount, "总在孵面积", incubatedAcreageCount);

    console.log("国家级科技企业孵化器:",lvMap[FUHUAQILV.国家级孵化器].count);
    console.log("国家级众创空间:",lvMap[FUHUAQILV.国家级众创空间].count);
    console.log("市级孵化器:",lvMap[FUHUAQILV.市级孵化器].count);
    console.log("市级众创空间:",lvMap[FUHUAQILV.市级众创空间].count);
    console.log("=====================");
    console.log("国有:",institutionalNatureMap[INSTITUTIONALNATURE.国资为主].count);
    console.log("民营:",institutionalNatureMap[INSTITUTIONALNATURE.民资为主].count);
    console.log("外资:",institutionalNatureMap[INSTITUTIONALNATURE.外资为主].count);
    console.log("=====================");
    console.log("人工智能及信息技术:",industryMap[INDUSTRY.人工智能及智能制造].count+industryMap[INDUSTRY.软件和信息服务业].count);
    console.log("生物医药:",industryMap[INDUSTRY.生物医药].count);
    console.log("集成电路:",industryMap[INDUSTRY.集成电路].count);
    console.log("综合及其他:",industryMap[INDUSTRY.航空航天].count+industryMap[INDUSTRY.汽车产业].count+industryMap[INDUSTRY.低碳环保及新材料].count+industryMap[INDUSTRY.综合].count+industryMap[INDUSTRY.文化创意].count);
    

    let enterpriseSelectParam = {
        "$or": [
            {
                "$and":[
                    {
                        "draftLock":true
                    }, 
                    {
                        "taskId":{
                            "$ne":null
                        }
                    }
                ]
            },
            {
                "$and": [
                    {
                        "draftLock":false
                    }, 
                    {
                        "taskId":null
                    }
                ]
            }
        ],
        state:{"$ne":FUHUASTATE.迁出}
    };
    let enterpriseList = await findEnterpriseList(enterpriseSelectParam);

    let count = 0;
    let nullCount = 0;
    let thisYearCount = 0;
    let thisYearCountMap = {};
    enterpriseList.forEach(info => {
        let {operatingAddress, logonAddress, fuHuaQiUscc, logonTime, industry, taskId, createTime, uscc, name} = info;
        if (createTime && createTime > new Date("2024-01-01 00:00:00").valueOf()) {
            // if (delList.indexOf(uscc) != -1) {
            //     return;
            // }
            let monthKey = moment(createTime).format("YYYYMM");
            if (!thisYearCountMap[monthKey])  {
                thisYearCountMap[monthKey] = {count:0};
                for (let key in INDUSTRY) {
                    let anyKey:any = key;
                    if (isNaN(anyKey)) {
                        let keyStr = key;
                        thisYearCountMap[monthKey][keyStr]= 0;
                    }
                }
            }
            thisYearCountMap[monthKey].count += 1;
            if (industry && industry[0]) thisYearCountMap[monthKey][changeEnumValue(INDUSTRY,industry[0])] += 1;
            thisYearCount += 1;
        }
        // if(taskId) {
        //     let taskIndex = taskId.slice(-5);
        //     if (taskIndex == "20242" || taskIndex == "20243" || taskIndex == "20244" || taskIndex == "20245") {
        //         if (!thisYearCountMap[taskIndex])  thisYearCountMap[taskIndex] = 0;
        //         thisYearCountMap[taskIndex] += 1;
        //         thisYearCount += 1;
        //     }
        // }
        if (logonAddress[0] && logonAddress[0] != "上海市" ) {
            // console.log("注册地不在上海+1");
            return;
        }
        if (logonAddress[1] && logonAddress[1] != "上海市" ) {
            // console.log("经营地不在上海+1");
            return;
        }
        // if (delList.indexOf(uscc) != -1) {
        //     // console.log("xxx");
        //     return;
        // }
        if(!logonAddress[0]) nullCount += 1;
        if (logonTime) {
            let yearLong = moment().diff(logonTime, 'years');
            if (industry.indexOf(INDUSTRY.人工智能及智能制造) != -1 || industry.indexOf(INDUSTRY.生物医药) != -1 || industry.indexOf(INDUSTRY.集成电路) != -1) {
                if (yearLong <= 5) count += 1;
            } else {
                if (yearLong <=4) count += 1;
            }
        }
        
        
    });
    console.log("本年累计新增",thisYearCount,"家");
    console.log("在孵企业",count);
    console.log("注册地址缺失:", nullCount);

    let wangList = [];


    //出租率
    let monthAVGList = [];
    for (let i = 1; i < 5; i++) {
        
        let monthList = await findMonthTableList({year:2024, month:i, draftLock:true});
        let thisMonthCheckCount = await findMonthTableListCount({year:2024, month:i, draftLock:true});

        let monthCount = 0;
        monthList.forEach(info => {
            let {occupancyRate, fuHuaQiUscc} = info;
            monthCount += occupancyRate;
            if (i == 4 && occupancyRate < 50) {
                wangList.push({name:fuHuaQiUsccNameMap[fuHuaQiUscc].opName, value:occupancyRate, acreageTotal:fuHuaQiUsccNameMap[fuHuaQiUscc].acreageTotal});
            }
        });
        let avg = Math.ceil((monthCount / monthList.length)*100)/100;
       
        monthAVGList.push(avg);

        if (i != 1) console.log(`${i}月发出填报要求105，有效填报${thisMonthCheckCount}份，未填报${105-thisMonthCheckCount}份共收集,月平均出租率${avg},环比${(avg-monthAVGList[i-2])>0 ? "上升":"下降"}${Math.abs(Math.round((avg-monthAVGList[i-2])*100)/100)}`);


        
    }
    console.log("=================");
    wangList.forEach(info => {
        console.log(info.name, " 出租率:", info.value, "  孵化面积", info.acreageTotal);
    });
    console.log("============");

    console.log("本月新增企业领域占比");
    let thisMonth = moment().format("YYYYMM");//本月
    for (let key in thisYearCountMap[thisMonth]) {
        if (key == "count") continue;
        let value = thisYearCountMap[thisMonth][key];
        if (value) {
            console.log(`${key}有${value}家,占比${Math.round((value/thisYearCountMap[thisMonth]["count"]) *10000 )/100}`);
        }
    }

    console.log();

}