/**
 * 走访
 */


import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const visitSchema = new Schema({
    id:String,//标识
    fuHuaQiUscc:String,//孵化器uscc
    uscc:{type:String, index:true},//企业uscc
    enterpriseName:String,
    visitTime:Number,
    accompany:String,//陪同人员
    leaderName:String,//出席领导
    researchType:Number, //调研类型 RESEARCHTYPE  
    desc:String,//解决的备注
    state:{type:Number, default:1},//1=初始状态  2=取消 3=完成  VISITSTATE
    createTime:Number,
    enterpriseType:{type:Number},//VISITENTERPRISETYPE
    // demand:{type:[Number], default:[]},//企业需求
    // demandDesc:String
});


var visitModel;
export function initModel(){
    visitModel = baseDB.model('visit', visitSchema);
    visitModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await visitModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}



export async function findOne(param) {
    return await visitModel.selectOnceData(param);
}


export async function findPageByParam(param, skipCount) {
    return await visitModel.find(param).skip(skipCount).limit(10);
}

export async function findByParam(param) {
    return await visitModel.find(param);
}


export async function findCountByParam(param) {
    return await visitModel.find(param).countDocuments();
}

export async function createDataByParam(param) {
    return await visitModel.create(param);
}


export async function removeOneData(id:string) {
    return await visitModel.deleteOne({id});
}