/**
 * 跟踪
 */


import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const trackSchema = new Schema({
    id:String,//标识
    fuHuaQiUscc:String,//孵化器uscc
    uscc:{type:String, index:true},//企业uscc
    enterpriseName:String,
    trackType:Number,//跟踪类型 VISITENTERPRISETYPE
    content:String,//内容
    createTime:Number
});


var trackModel;
export function initModel(){
    trackModel = baseDB.model('visittrack', trackSchema);
    trackModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await trackModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 
 * @param uscc 孵化器统一信用代码
 * @returns 
 */
export async function findOne(param) {
    return await trackModel.selectOnceData(param);
}

/**通过条件查询孵化器得分信息 */
export async function findByParam(param) {
    return await trackModel.find(param);
}

export async function findCountByParam(param) {
    return await trackModel.find(param).countDocuments();
}

export async function createDataByParam(param) {
    return await trackModel.create(param);
}


export async function removeOneData(id:string) {
    return await trackModel.deleteOne({id});
}