/**
 * 得分日志表
 * 
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const fuhuaqiscorelogRepairSchema = new Schema({
    uscc:{type:String, index:true},//孵化器uscc
    ways:Number,//途径 遵循枚举 SCOREWAYS 值
    taskType:Number,//任务类型 遵循枚举 TASKTYPEENUM 值
    changeMode:Number,//分数变化方式 遵循枚举 CHANGEMODE 值
    score:Number,//变化后的分数
    addScore:Number,//增加/减少的分数
    timeMs:{type:Number, index:true}//获得时间  时间戳
});


var fuhuaqiscorelogRepairModel;
export function initModel(){
    fuhuaqiscorelogRepairModel = baseDB.model('fuhuaqiscorelogRepair', fuhuaqiscorelogRepairSchema);
}


/**
 * 批量添加得分日志
 * @param addList 添加列表
 */
export async function addMany_repair(addList) {
    await fuhuaqiscorelogRepairModel.insertMany(addList);
}


export async function getAllLog_repair(param) {
    return await fuhuaqiscorelogRepairModel.find(param);
}