/**
 * 得分日志表
 * 
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const fuHuaQiScoreLogSchema = new Schema({
    uscc:{type:String, index:true},//孵化器uscc
    ways:Number,//途径 遵循枚举 SCOREWAYS 值
    taskType:Number,//任务类型 遵循枚举 TASKTYPEENUM 值
    changeMode:Number,//分数变化方式 遵循枚举 CHANGEMODE 值
    score:Number,//变化后的分数
    addScore:Number,//增加/减少的分数
    timeMs:{type:Number, index:true}//获得时间  时间戳
});


var fuHuaQiScoreLogModel;
export function initModel(){
    fuHuaQiScoreLogModel = baseDB.model('fuhuaqiscorelog', fuHuaQiScoreLogSchema);
}


/**
 * 添加得分日志
 * @param ways 途径
 * @param changeMode 增加或减少
 * @param uscc 孵化器uscc 
 * @param score 分数
 * @param addScore 增加/删除分数
 * @param taskType  任务类型  选填
 */
export async function addLog(uscc:string, ways:number, changeMode:number, score:number, addScore:number, taskType?) {
    let addInfo:any = {uscc, ways, changeMode, score, addScore, timeMs:new Date().valueOf() };
    if (taskType) addInfo.taskType = taskType;
    await fuHuaQiScoreLogModel.create(addInfo);
}


/**
 * 批量添加得分日志
 * @param addList 添加列表
 */
export async function addMany(addList) {
    await fuHuaQiScoreLogModel.insertMany(addList);
}

/**
 * 获取得分列表
 * @param uscc 孵化器uscc 
 * 
 */
export async function getLog(uscc:string, startTime:number, endTime:number) {
    return await fuHuaQiScoreLogModel.find({uscc, timeMs:{"$gt":startTime, "$lt":endTime} });
}


/**
 * 查询孵化器最新的分数
 * @param timeMs 
 * @returns 
 */
export async function getUptotheminuteScore(param) {
    return await fuHuaQiScoreLogModel.aggregate([
        {"$match":param },
        {"$group":{_id:"$uscc", maxScore:{"$last":"$score"} } }
    ]);
}


/**
 * 添加得分日志 初始化用
 * @param ways 途径
 * @param changeMode 增加或减少
 * @param uscc 孵化器uscc 
 * @param score 分数
 * @param addScore 增加/删除分数
 * @param taskType  任务类型  选填
 */
export async function addLogTOInitData(uscc:string, ways:number, changeMode:number, score:number, addScore:number, timeMs:number, taskType?) {
    let addInfo:any = {uscc, ways, changeMode, score, addScore, timeMs };
    if (taskType) addInfo.taskType = taskType;
    await fuHuaQiScoreLogModel.create(addInfo);
}


export async function getAllLog() {
    return await fuHuaQiScoreLogModel.find({ });
}

export async function getLogByParam(param) {
    return await fuHuaQiScoreLogModel.find(param);
}

export async function updateLog(uscc:string, timeMs:number,ways:number,taskType:number, newTimeMs:number) {
    return await fuHuaQiScoreLogModel.updateOne({uscc, ways, taskType, timeMs}, {"$set":{timeMs:newTimeMs}});
}

export async function removeLogByParam(param) {
    await fuHuaQiScoreLogModel.deleteMany(param);
}

export async function updateInfo(param, updateInfo) {
    return await fuHuaQiScoreLogModel.updateOne(param, {"$set":updateInfo});
}

export async function getNewLog(uscc) {
    return await fuHuaQiScoreLogModel.findOne({uscc}).sort({timeMs:-1});
}