/**
 * 孵化器任务表
 * 任务标识为 YYYYMM  
 * 任务id 格式遵循tool中getTaskId
 * 每种任务一个月只能提交一次  2023-02-06 确定此需求
 * 任务提交之后将不会出现在列表中  2023-02-06 确定此需求
 * 任务不能提交后不能修改和删除 2023-02-06 确定此需求
 * type 依赖枚举
 * 
 * 注释  1.key 的规则是 YYYYMM  年月为发放任务时的 年月
 *       2.month为 数据的月份，例如 key = 20235  那 month = 4, 年份(year)同理
 * 
 */
import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';

const fuHuaQiTaskSchema = new Schema({
    key:{type:Number, index:true},//任务标识  格式为:YYYYM 
    type: {type:Number,index:true},//任务类型
    taskId:String,//任务id
    fuHuaQiUscc:String,//任务所属孵化器id
    submitTime:Number,//提交时间
    // relevanceId:String,//任务关联的表 financing 或 enterprise 的id  弃用
    isSubmit:Boolean,//是否提交
    month:Number,//数据的月
    year:Number,//数据的年 2.0算分的时候加入的
    submitCount:{type:Number, default:0},//提交数量  默认0
    startTime:{type:Number, default:0},//任务开始时间 6.0加入
    endTime:{type:Number, default:0},//任务结束时间 6.0加入
    customTaskId:{type:String}//自定义任务id 用于找关联数据

});

var fuHuaQiTaskModel;
export function initModel(){
    fuHuaQiTaskModel = baseDB.model('fuHuaQiTask', fuHuaQiTaskSchema);
    fuHuaQiTaskModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await fuHuaQiTaskModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 通过任务id 查询孵化器任务
 * @param taskId 任务id
 * @returns {}  格式: key=type  value={isSubmit}
 */
export async function findFuHuaQiTaskByTaskId(taskId:string) {
    let findList = await fuHuaQiTaskModel.find({taskId}).exec() || [];
    let taskMap = {};
    findList.forEach(item => {
        taskMap[item.type] = {isSubmit:item.isSubmit, month:item.month, customTaskId:item.customTaskId};
    });
    return taskMap;
}


/**
 * 通过任务id和类型获取任务信息
 * 支持.save方法保存对象修改
 * @param taskId 任务id
 * @param type 任务类型
 * @returns {}
 */
export async function findEnterpriseByTaskIdAndType(taskId:string, type:number) {
    return await fuHuaQiTaskModel.selectOnceData({taskId, type});
}


// /**
//  * 根据任务标识查询任务列表
//  * @param key 任务标识
//  * @returns 
//  */
// export async function findTaskCountByKey(key:number) {
//     return await fuHuaQiTaskModel.find({key}).countDocuments();
// }


/**
 * 批量创建任务
 * @param taskList 任务列表
 */
export async function createTaskToList(taskList:object) {
    await fuHuaQiTaskModel.insertMany(taskList);
}


/**
 * 更具条件查询任务列表
 * @param param 
 * @returns 
 */
export async function findTaskListByParam(param) {
    let taskList = await fuHuaQiTaskModel.find(param);
    return taskList;
}


/**
 * 将所有数据的年份加上 2023 
 * 2.0上线后去掉
 * @param state 孵化状态
 */
export async function updateTaskYearData(year:number) {
    return await fuHuaQiTaskModel.updateMany({}, {$set:{year}});
}


export async function upodateTaskStartAdnEndTime(selectParam, updateParam) {
    return await fuHuaQiTaskModel.updateMany(selectParam, {$set:updateParam});
}

/**
 * 根据条件分页查询任务列表
 * @param selectParam 查询条件
 * @param skipCount 分页标识
 * @returns 
 */
export async function findTaskListByParamAndPage(selectParam, skipCount:number) {
    return await fuHuaQiTaskModel.find(selectParam).skip(skipCount).limit(10);
}


/**
 * 根据条件查询 任务数
 * @param selectParam 查询条件
 * @returns 
 */
export async function findTaskCountByParamCount(selectParam) {
    return await fuHuaQiTaskModel.find(selectParam).countDocuments();
}


/**数据维护 */
export async function updateSubmitCount(taskId:string, type:number, count:number) {
    await fuHuaQiTaskModel.updateOne({type, taskId}, {$set:{submitCount:count}});
}

/**
 * 6.0数据维护
 */
export async function updateTaskCustomTaskId(year:number, month:number, customTaskId:string) {
    await fuHuaQiTaskModel.updateOne({month, year}, {$set:{customTaskId:customTaskId}});
}

/**
 * 获取单个月的所有孵化器的填报率
 * @param year 
 * @param month 
 * @returns 
 */
export async function statsFuHuaQiTaskReportingRate(year:number, month:number) {
    let statsList = await fuHuaQiTaskModel.aggregate([
        {"$match":{year, month}},
        {"$group":{_id:{uid:"$fuHuaQiUscc", isSubmit:"$isSubmit"}, count:{"$sum":1} } }
    ]);

    return statsList;
}


export async function findOneFuHuaQiMonthTaskData(selectParam) {
    return await fuHuaQiTaskModel.findOne(selectParam);
}



/**
 * 填报周期
 */
export async function distinctCycle() {
    return await fuHuaQiTaskModel.aggregate([{"$group":{
        _id:{year:"$year", month:"$month"} 
    }}]);
}


export async function statsTaskYearAndMonth() {
    return await fuHuaQiTaskModel.aggregate([{"$group":{
        _id:{year:"$year", month:"$month"} 
    }}]);
}