/**
 * 孵化器月度填报表 
 * draftLock 草稿锁 当任务提交的时候，将此字段改为true
 * occupancyRate 取%号前的数据 例如 填报数据为80%  库中数据为80
 * name 为系统生成 此月填报上一月内容 即2月填报时 name中月份为1月  2023-02-06 确定此需求
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';
import { STATEENUM } from '../../../config/enum';

/**党支部登记 */
const zfqydzbdjSchema = new Schema({
    name:String,//支部名称
    type:Number,//支部类型 ZHIBUTYPEENUM
    count:Number,//党员数量
    dzbsfkzshyk:Boolean,//党支部是否开展三会一课
    hdcs:Number,//活动次数
    cyrs:Number,//参与人数
},{_id:false});

const dangJianTableSchema = new Schema({
    taskId:{type:String, index:true},//任务id
    key:{type:Number, index:true},//年度  2024  格式是YYYY
    fuHuaQiUscc:{type:String, index:true},//孵化器uscc
    /**众创孵化器信息采集 */
    zcdszdy:{type:Number, default:STATEENUM.未选},//董事长是党员 STATEENUM
    szzcfhjgdyrs:Number,//所在众创孵化机构党员人数
    zcfhjgsfjsdjyd:{type:Number, default:STATEENUM.未选},//众创孵化机构是否建设党建园地 STATEENUM
    zcjgsfcldzs:{type:Number, default:STATEENUM.未选},//众创孵化机构是否成立党支部  STATEENUM
    zcjgsfcldzslx:Number,//众创孵化机构党支部类型  SZZCFHJGSFCLDZBENUM
    zbmc:String,//支部名称
    dzbsfkzshyk:Boolean,//党支部是否开展三会一课
    hdcs:Number,//活动次数
    cyrs:Number,//参与人数
    /**在孵企业信息采集 */
    zfqydysl:Number,//在孵企业党员数量
    zfqycsrszgdysl:Number,//在孵企业是中共党员数量
    dy70h:Number,//70后
    dy80h:Number,//80后
    dy90h:Number,//90后
    jy:String,//建议
    zfqydj:{type:Number, default:STATEENUM.未选},//在孵企业党建 STATEENUM
    zfqydzbdjList:{type:[zfqydzbdjSchema], default:[]},//党支部登记
    //提交状态
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
    submitTime:Number,//提交时间
    customTaskId:{type:String}//自定义任务id 用于找关联数据
});

var dangJianTableModel;
export function initModel(){
    dangJianTableModel = baseDB.model('dangJianTable', dangJianTableSchema);
    dangJianTableModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await dangJianTableModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}



export async function findCountByParam(param) {
    return await dangJianTableModel.find(param).countDocuments();
}

/**
 * 批量创建任务
 * @param taskList 任务列表
 */
export async function createTaskToList(taskList:object) {
    await dangJianTableModel.insertMany(taskList);
}


export async function findDangJianTaskListByTaskId(taskId:string) {
    return await dangJianTableModel.selectOnceData({taskId});
}
